/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.kakuro.Panel;

public class Menu
extends MenuBase {
    private JMenuItem wallColorItem;
    private JMenuItem numberColorItem;
    private JMenuItem inputColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem dotHintItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        this.addCursorMenuItem();
        super.buildViewMenu();
        this.wallColorItem = this.addColorMenuItem("\u9ed2\u30de\u30b9");
        this.numberColorItem = this.addColorMenuItem("\u554f\u984c\u6570\u5b57");
        this.inputColorItem = this.addColorMenuItem("\u89e3\u7b54\u6570\u5b57");
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem("\u8aa4\u308a\u3092\u8d64\u3067\u793a\u3059(E)", 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.dotHintItem = this.makeCheckBoxCommandMenuItem("\u53ef\u80fd\u306a\u6570\u5b57\u3092\u30c9\u30c3\u30c8\u3067\u793a\u3059(D)", 'D', false);
        this.addToViewMenu(this.dotHintItem);
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.dotHintItem) {
            this.getPanel().setDotHintMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.inputColorItem) {
            return this.getPanel().getInputColor();
        }
        if (target == this.wallColorItem) {
            return this.getPanel().getWallColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.inputColorItem) {
            this.getPanel().setInputColor(color);
        } else if (target == this.wallColorItem) {
            this.getPanel().setWallColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    protected void buildRotationMenu() {
        super.buildRotationMenu2();
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.dotHintItem.setSelected(this.getPanel().isDotHintMode());
    }
}

