/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private boolean separateLinkColorMode = false;
    private boolean highlightSelectionMode = false;
    private Link selectedLink = null;
    private int selectedNumber = 0;
    private Color highlightColor = Color.GREEN;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isHighlightSelectionMode() {
        return this.highlightSelectionMode;
    }

    public void setHighlightSelectionMode(boolean highlightSelectionMode) {
        this.highlightSelectionMode = highlightSelectionMode;
    }

    protected Link getSelectedLink() {
        return this.selectedLink;
    }

    protected void setSelectedLink(Link selectedLink) {
        this.selectedLink = selectedLink;
    }

    protected int getSelectedNumber() {
        return this.selectedNumber;
    }

    protected void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawNumbers(g);
        this.drawBoardBorder(g);
    }

    private void drawLinks(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        this.placeLink1(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0) {
                    g.setColor(this.getBackgroundColor());
                    this.placeFilledCircle(g, r, c);
                    g.setColor(this.getNumberColor());
                    this.placeNumber1(g, r, c, number);
                } else if (number == -1) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void placeLink1(Graphics2D g, int d, int r, int c) {
        Link link = this.board.getLink(d, r, c);
        int linkNo = link.getNumber();
        g.setColor(this.getLineColor());
        if (this.isSeparateLinkColorMode()) {
            if (linkNo == 0) {
                g.setColor(this.getLineColor());
            } else if (linkNo == -1) {
                g.setColor(this.getErrorColor());
            } else {
                g.setColor(Colors.getDarkColor(linkNo));
            }
        }
        if (this.isHighlightSelectionMode() && (linkNo > 0 && linkNo == this.getSelectedNumber() || link == this.getSelectedLink())) {
            g.setColor(this.highlightColor);
        }
        super.placeLink(g, d, r, c);
    }

    private void placeNumber1(Graphics2D g, int r, int c, int n) {
        if (this.isHighlightSelectionMode() && n == this.getSelectedNumber()) {
            g.setColor(this.highlightColor);
            super.paintCell(g, r, c);
        }
        g.setColor(this.getNumberColor());
        if (this.isSeparateLinkColorMode()) {
            g.setColor(Colors.getDarkColor(this.board.getNumber(r, c)));
        }
        super.placeNumber(g, r, c, n);
    }
}

