/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.slitherlink.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean separateLinkColorMode = false;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;

    public Panel() {
        this.setGridColor(Color.BLACK);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawLinks(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    public void drawGrid(Graphics2D g) {
        if (this.getGridStyle() == 0) {
            return;
        }
        g.setColor(this.getGridColor());
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.fillSquare(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), 1);
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r = 0;
        while (r < this.board.rows() - 1) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                int number = this.board.getNumber(r, c);
                if (number >= 0 && number <= 4) {
                    g.setColor(this.getNumberColor());
                    if (this.isIndicateErrorMode()) {
                        int nline = this.board.lineAround(r, c);
                        if (nline > number) {
                            g.setColor(this.getErrorColor());
                        } else if (nline < number) {
                            g.setColor(this.getErrorColor());
                        }
                    }
                    this.placeNumber2(g, r, c, number);
                } else if (number == 5) {
                    this.placeCircle2(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawLinks(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        g.setColor(this.getLineColor());
                        if (this.isSeparateLinkColorMode()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r, c).getID()));
                        }
                        this.placeLink(g, d, r, c);
                    } else if (state == -1) {
                        g.setColor(this.getCrossColor());
                        this.placeSideCross(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    protected void placeNumber2(Graphics2D g, int r, int c, int num) {
        this.drawString(g, this.toX(c + 1), this.toY(r + 1), Integer.toString(num));
    }

    protected void placeCircle2(Graphics2D g, int r, int c) {
        int x = this.toX(c) + this.getCellSize();
        int y = this.toY(r) + this.getCellSize();
        this.drawCircle(g, x, y, this.getCircleSize() / 2);
        this.drawCircle(g, x, y, this.getCircleSize() / 2 - 1);
    }

    public void drawCursor(Graphics2D g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize(), this.toY(this.getCellCursor().r()) + this.getHalfCellSize(), this.getCellSize(), this.getCellSize());
            g.drawRect(this.toX(this.getCellCursor().c()) + this.getHalfCellSize() + 1, this.toY(this.getCellCursor().r()) + this.getHalfCellSize() + 1, this.getCellSize() - 2, this.getCellSize() - 2);
        }
    }
}

