/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.slitherlink.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem lineColorItem;
    private JMenuItem crossColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateLinkColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem("\u6570\u5b57");
        this.lineColorItem = this.addColorMenuItem("\u7dda");
        this.crossColorItem = this.addColorMenuItem("\u00d7\u5370");
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem("\u8aa4\u308a\u3092\u8d64\u3067\u793a\u3059(E)", 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateLinkColorItem = this.makeCheckBoxCommandMenuItem("\u7dda\u306e\u8272\u5206\u3051(R)", 'R', false);
        this.addToViewMenu(this.separateLinkColorItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateLinkColorItem) {
            this.getPanel().setSeparateLinkColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.crossColorItem) {
            return this.getPanel().getCrossColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.crossColorItem) {
            this.getPanel().setCrossColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.separateLinkColorItem.setSelected(this.getPanel().isSeparateLinkColorMode());
    }
}

