/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private Color areaBorderColor = Color.BLUE;
    private Color smallSizeColor = new Color(0xFFFF80);
    private Color areaPaintColor = new Color(0x80FFFF);
    private Square draggingArea;
    private boolean separateAreaColorMode = false;
    private boolean indicateErrorMode = false;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaPaintColor() {
        return this.areaPaintColor;
    }

    public void setAreaPaintColor(Color areaPaintColor) {
        this.areaPaintColor = areaPaintColor;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                Square area = this.board.getSquare(r, c);
                if (area != null) {
                    g.setColor(this.areaPaintColor);
                    if (this.isIndicateErrorMode()) {
                        int number = area.getNumber();
                        if (number == -2) {
                            g.setColor(this.getErrorColor());
                        } else if (number == 0) {
                            g.setColor(this.smallSizeColor);
                        } else if (number == -1) {
                            g.setColor(this.areaPaintColor);
                        } else if (number < area.getSquareSize()) {
                            g.setColor(this.getErrorColor());
                        } else if (number == area.getSquareSize()) {
                            g.setColor(this.areaPaintColor);
                        } else if (number > area.getSquareSize()) {
                            g.setColor(this.smallSizeColor);
                        }
                    } else if (this.isSeparateAreaColorMode()) {
                        g.setColor(Colors.getBrightColor(this.board.getSquare(r, c).getId()));
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0 || number == -1) {
                    g.setColor(this.getNumberColor());
                    super.placeFilledCircle(g, r, c, (int)((double)this.getCellSize() * 0.85));
                }
                if (number > 0) {
                    g.setColor(this.getBackgroundColor());
                    super.placeNumber(g, r, c, number);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        Square area;
        g.setColor(this.getAreaBorderColor());
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            area = (Square)itr.next();
            this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
        }
        area = this.getDraggingArea();
        if (area != null) {
            this.placeSquare(g, area.r0, area.c0, area.r1, area.c1);
        }
    }

    void setDraggingArea(Square draggingArea) {
        this.draggingArea = draggingArea;
    }

    Square getDraggingArea() {
        return this.draggingArea;
    }
}

