/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Property;
import pencilbox.common.core.Size;
import pencilbox.common.io.XmlConstants;
import pencilbox.common.io.XmlPrintWriter;

public abstract class XmlWriterBase
implements XmlConstants {
    private String puzzleType;
    private BoardBase board;
    private Property property;
    private int col;
    private int len;
    private String elm;
    protected XmlPrintWriter writer;
    private int indent;
    private char[] char1Store = new char[1];

    protected void writeProblem(Problem problem) {
        this.board = problem.getBoard();
        this.property = problem.getProperty();
        this.outHeader();
        this.outSize();
        this.outProperty();
        this.startBoard();
        this.setBoardData(this.board);
        this.endBoard();
        this.startAnswer();
        this.setAnswerData(this.board);
        this.endAnswer();
        this.outTail();
    }

    protected void setBoardData(BoardBase board) {
        throw new UnsupportedOperationException("setBoardData \u672a\u4f5c\u6210");
    }

    protected void setAnswerData(BoardBase board) {
        throw new UnsupportedOperationException("setAnswerData \u672a\u4f5c\u6210");
    }

    protected XmlPrintWriter open(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        this.writer = new XmlPrintWriter(osw);
        return this.writer;
    }

    protected void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
        this.writer = null;
    }

    protected void startTag(int level, String tag) {
        this.writer.print(level, "<" + tag);
    }

    protected void startTag(String tag) {
        this.startTag(this.indent++, tag);
    }

    protected void closeTag() {
        this.writer.println(">");
    }

    protected void emptyTag() {
        this.writer.println("/>");
        --this.indent;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    protected void endTag(int level, String tag) {
        this.writer.println(level, "</" + tag + ">");
    }

    protected void endTag(String tag) {
        this.writer.println();
        --this.indent;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.endTag(this.indent, tag);
    }

    protected void attribute(String attr, String value) {
        this.writer.print(" " + attr + "=\"" + value + "\"");
    }

    protected void attribute(String attr, int value) {
        this.writer.print(" " + attr + "=\"" + value + "\"");
    }

    protected void indent() {
        this.writer.printIndent(this.indent);
    }

    protected void outHeader() {
        this.outHeader(this.puzzleType);
    }

    protected void outHeader(String type) {
        this.writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        this.writer.println("<puzzle type=\"" + type + "\">");
    }

    protected void outTail() {
        this.writer.println("</puzzle>");
        this.writer.close();
    }

    protected void outSize() {
        Size size = this.board.getSize();
        this.outSize(size);
    }

    protected void outSize(int rows, int cols) {
        this.writer.println(1, "<size row=\"" + rows + "\" col=\"" + cols + "\"/>");
    }

    protected void outSize(Size size) {
        StringBuffer text = new StringBuffer("<size");
        if (size.getRows() != 0) {
            text.append(" row=\"" + size.getRows() + "\"");
        }
        if (size.getCols() != 0) {
            text.append(" col=\"" + size.getCols() + "\"");
        }
        text.append(" />");
        this.writer.println(1, text.toString());
    }

    protected void outProperty() {
        this.startTag("property");
        this.closeTag();
        this.startTag("author");
        this.attribute("value", this.property.getAuthor());
        this.emptyTag();
        this.startTag("source");
        this.attribute("value", this.property.getSource());
        this.emptyTag();
        this.startTag("difficulty");
        this.attribute("value", this.property.getDifficulty());
        this.emptyTag();
        this.endTag("property");
    }

    protected void startBoard() {
        this.writer.println(1, "<board>");
    }

    protected void endBoard() {
        this.writer.println(1, "</board>");
    }

    void rowBegin() {
        this.col = 0;
        this.len = 0;
        this.elm = "";
    }

    protected void startBrow(int r) {
        this.writer.println(2, "<brow row=\"" + (r + 1) + "\">");
        this.writer.printIndent(3);
        this.rowBegin();
    }

    protected void endBrow() {
        this.out("row_end_marker");
        this.writer.println();
        this.writer.println(2, "</brow>");
    }

    protected void startAnswer() {
        this.writer.println(1, "<answer>");
    }

    protected void endAnswer() {
        this.writer.println(1, "</answer>");
    }

    protected void startArow(int r) {
        this.writer.println(2, "<arow row=\"" + (r + 1) + "\">");
        this.writer.printIndent(3);
        this.rowBegin();
    }

    protected void endArow() {
        this.out("row_end_marker");
        this.writer.println();
        this.writer.println(2, "</arow>");
    }

    void flushElm() {
        if (this.len == 0) {
            return;
        }
        switch (this.len) {
            case 0: {
                break;
            }
            case 2: {
                this.writer.print("<" + this.elm + "/>");
                this.writer.print("<" + this.elm + "/>");
                break;
            }
            case 1: {
                this.writer.print("<" + this.elm + "/>");
                break;
            }
            default: {
                this.writer.print("<" + this.elm + " n=\"" + this.len + "\"/>");
            }
        }
        this.col += this.len;
        this.len = 0;
    }

    protected void out(String newElm) {
        if (!this.elm.equals(newElm)) {
            this.flushElm();
            this.elm = newElm;
        }
        ++this.len;
        ++this.col;
    }

    protected void out(char c) {
        this.char1Store[0] = c;
        String s = new String(this.char1Store);
        this.writer.print("<c v=\"" + s + "\"/>");
    }

    protected void outN(int v) {
        if (v >= 0 && v <= 9) {
            switch (v) {
                case 0: {
                    this.out("z");
                    break;
                }
                case 1: {
                    this.out("n1");
                    break;
                }
                case 2: {
                    this.out("n2");
                    break;
                }
                case 3: {
                    this.out("n3");
                    break;
                }
                case 4: {
                    this.out("n4");
                    break;
                }
                case 5: {
                    this.out("n5");
                    break;
                }
                case 6: {
                    this.out("n6");
                    break;
                }
                case 7: {
                    this.out("n7");
                    break;
                }
                case 8: {
                    this.out("n8");
                    break;
                }
                case 9: {
                    this.out("n9");
                }
            }
        } else {
            this.flushElm();
            this.writer.print("<n v=\"" + v + "\"/>");
            this.len = 0;
            ++this.col;
            this.elm = "n";
        }
    }

    protected void outNumber(int r, int c, int n) {
        this.startTag(2, "number");
        this.attribute("r", r + 1);
        this.attribute("c", c + 1);
        this.attribute("n", n);
        this.emptyTag();
    }

    public void setPuzzleType(String puzzleType) {
        this.puzzleType = puzzleType;
    }
}

