/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.common.gui.TreeMapA;

public class PreferencesCopierBase {
    private String pencilName;
    private Properties properties = new Properties();

    public static PreferencesCopierBase createInstance(PencilType pencilType) {
        PreferencesCopierBase copier;
        try {
            copier = (PreferencesCopierBase)ClassUtil.createInstance(pencilType, "PreferencesCopier");
        }
        catch (PencilBoxClassException ex) {
            copier = new PreferencesCopierBase();
        }
        copier.pencilName = String.valueOf(pencilType.getPencilName()) + '.';
        return copier;
    }

    public void applyCurrentPreferences(MenuCommand command) {
        PanelBase panel = command.getPanelBase();
        PanelEventHandlerBase handler = command.getPanelEventHandlerBase();
        handler.setProblemEditMode(this.getBooleanProperty("EditMode"));
        handler.setSymmetricPlacementMode(this.getBooleanProperty("SymmetricPlacementMode"));
        handler.setImmediateAnswerCheckMode(this.getBooleanProperty("ImmediateAnswerCheckMode"));
        panel.setDisplaySize(this.getIntProperty("CellSize"));
        panel.changeIndexMode(this.getBooleanProperty("IndexMode"));
        panel.setGridStyle(this.getIntProperty("GridStyle"));
        panel.setMarkStyle(this.getIntProperty("MarkStyle"));
        panel.setCursorMode(this.getBooleanProperty("CursorMode"));
        panel.setBackgroundColor(this.getColorProperty("BackgroundColor"));
        panel.setGridColor(this.getColorProperty("GridColor"));
    }

    public void acquireCurrentPreferences(MenuCommand command) {
        PanelBase panel = command.getPanelBase();
        PanelEventHandlerBase handler = command.getPanelEventHandlerBase();
        this.setBooleanProperty("EditMode", panel.isProblemEditMode());
        this.setBooleanProperty("SymmetricPlacementMode", handler.isSymmetricPlacementMode());
        this.setBooleanProperty("ImmediateAnswerCheckMode", handler.isImmediateAnswerCheckMode());
        this.setIntProperty("CellSize", panel.getCellSize());
        this.setBooleanProperty("IndexMode", panel.isIndexMode());
        this.setIntProperty("GridStyle", panel.getGridStyle());
        this.setIntProperty("MarkStyle", panel.getMarkStyle());
        this.setBooleanProperty("CursorMode", panel.isCursorMode());
        this.setColorProperty("BackgroundColor", panel.getBackgroundColor());
        this.setColorProperty("GridColor", panel.getGridColor());
    }

    public void copyPreferences(MenuCommand src, MenuCommand dst) {
        this.acquireCurrentPreferences(src);
        this.applyCurrentPreferences(dst);
    }

    public void loadPreferences(MenuCommand command, File file) {
        this.acquireCurrentPreferences(command);
        try {
            this.properties.load(new FileInputStream(file));
            this.applyCurrentPreferences(command);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void storePreferences(MenuCommand command, File file) {
        try {
            if (file.canRead()) {
                this.properties.load(new FileInputStream(file));
            }
            this.acquireCurrentPreferences(command);
            TreeMapA map = new TreeMapA((Map)this.properties);
            map.store(new FileOutputStream(file), "PencilBox preferences");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getStringProperty(String key) {
        return this.properties.getProperty(String.valueOf(this.pencilName) + key);
    }

    protected boolean getBooleanProperty(String key) {
        return Integer.parseInt(this.properties.getProperty(String.valueOf(this.pencilName) + key)) > 0;
    }

    protected int getIntProperty(String key) {
        return Integer.parseInt(this.properties.getProperty(String.valueOf(this.pencilName) + key));
    }

    protected Color getColorProperty(String key) {
        return Color.decode(this.properties.getProperty(String.valueOf(this.pencilName) + key));
    }

    protected void setStringProperty(String key, String value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key, value);
    }

    protected void setBooleanProperty(String key, boolean value) {
        int i = value ? 1 : 0;
        this.properties.setProperty(String.valueOf(this.pencilName) + key, Integer.toString(i));
    }

    protected void setIntProperty(String key, int value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key, Integer.toString(value));
    }

    protected void setColorProperty(String key, Color value) {
        this.properties.setProperty(String.valueOf(this.pencilName) + key, this.getColorString(value));
    }

    public String getColorString(Color color) {
        return String.format("0x%06X", color.getRGB() & 0xFFFFFF);
    }
}

