/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PencilBoxDialog;

public class CellSizeDialog
extends PencilBoxDialog
implements MouseWheelListener {
    private static CellSizeDialog instance = new CellSizeDialog();
    static final int VALUE_MIN = 8;
    static final int VALUE_MAX = 80;
    static final int VALUE_INIT = 26;
    private JSlider slider;
    private JSpinner spinner;
    private PanelBase panel;

    public static CellSizeDialog getInstance() {
        return instance;
    }

    private CellSizeDialog() {
    }

    protected void makeDialog() {
        this.setDialogType(1);
        super.makeDialog();
        this.makeMainPanel();
    }

    public void setPanel(PanelBase p) {
        this.panel = p;
    }

    private void makeMainPanel() {
        JPanel mainPanel = new JPanel();
        this.makeSlider();
        this.makeSpinner();
        mainPanel.add(this.slider);
        mainPanel.add(this.spinner);
        this.add((Component)mainPanel, "North");
        this.addMouseWheelListener(this);
    }

    private void makeSlider() {
        this.slider = new JSlider(0, 8, 80, 26);
        this.slider.setMajorTickSpacing(12);
        this.slider.setMinorTickSpacing(2);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = CellSizeDialog.this.slider.getValue();
                if (CellSizeDialog.this.slider.getValueIsAdjusting()) {
                    CellSizeDialog.this.spinner.setValue(value);
                } else {
                    CellSizeDialog.this.spinner.setValue(value);
                    CellSizeDialog.this.panel.setDisplaySize(value);
                }
            }
        });
    }

    private void makeSpinner() {
        SpinnerNumberModel numberModel = new SpinnerNumberModel(26, 8, 80, 1);
        this.spinner = new JSpinner(numberModel);
        this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner, "#"));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = ((SpinnerNumberModel)CellSizeDialog.this.spinner.getModel()).getNumber().intValue();
                CellSizeDialog.this.slider.setValue(value);
            }
        });
    }

    public int getCellSize() {
        return this.slider.getValue();
    }

    public void setCellSize(int cellSize) {
        this.slider.setValue(cellSize);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.setCellSize(this.getCellSize() + e.getWheelRotation());
    }
}

