/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;
import pencilbox.common.core.Address;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;

public class BoardBase {
    private UndoManager undoManager;
    private Size size;
    public static final String COMPLETE_MESSAGE = "\u6b63\u89e3\u3067\u3059";

    public void setSize(Size size) {
        this.size = size;
        this.setup();
    }

    protected void setup() {
    }

    public void setUndoManager(UndoManager u) {
        this.undoManager = u;
    }

    public Size getSize() {
        return this.size;
    }

    public final int rows() {
        return this.size.getRows();
    }

    public final int cols() {
        return this.size.getCols();
    }

    public boolean isOn(int r, int c) {
        return r >= 0 && r < this.rows() && c >= 0 && c < this.cols();
    }

    public boolean isOn(int r, int c, int adjustRow, int adjustCol) {
        return r >= 0 && r < this.rows() + adjustRow && c >= 0 && c < this.cols() + adjustCol;
    }

    public boolean isOn(Address position) {
        return this.isOn(position.r(), position.c());
    }

    public boolean isSideOn(int d, int r, int c) {
        if (d == 0) {
            return r >= 0 && r < this.rows() && c >= 0 && c < this.cols() - 1;
        }
        if (d == 1) {
            return r >= 0 && r < this.rows() - 1 && c >= 0 && c < this.cols();
        }
        return false;
    }

    public boolean isSideOn(SideAddress position) {
        return this.isSideOn(position.d(), position.r(), position.c());
    }

    public void clearBoard() {
    }

    public void trimAnswer() {
    }

    public void initBoard() {
    }

    public boolean isOnPeriphery(int r, int c) {
        return r == 0 || r == this.rows() - 1 || c == 0 || c == this.cols() - 1;
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        this.undoManager.undoableEditHappened(e);
    }

    public String checkAnswerString() {
        return "\u5224\u5b9a\u6a5f\u80fd\u304c\u3042\u308a\u307e\u305b\u3093";
    }

    public int checkAnswerCode() {
        return 0;
    }
}

