/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.sudoku.Board;
import pencilbox.sudoku.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.rows());
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r(), pos.c()))) {
            this.board.increaseNumber(pos.r(), pos.c());
        }
        this.setSelectedNumber(this.board.getNumber(pos.r(), pos.c()));
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos.r(), pos.c()))) {
            this.board.decreaseNumber(pos.r(), pos.c());
        }
        this.setSelectedNumber(this.board.getNumber(pos.r(), pos.c()));
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeNumber(pos.r(), pos.c(), num);
                this.board.setState(pos.r(), pos.c(), 1);
                if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS.r(), posS.c())) {
                    this.board.setState(posS.r(), posS.c(), 1);
                    this.board.changeNumber(posS.r(), posS.c(), 0);
                }
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && this.board.isStable(posS.r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 0);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos.r(), pos.c())) {
            this.board.enterNumberA(pos.r(), pos.c(), 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos.r(), pos.c(), 0);
            this.board.setState(pos.r(), pos.c(), 1);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS.r(), posS.c())) {
                this.board.setState(posS.r(), posS.c(), 1);
                this.board.changeNumber(posS.r(), posS.c(), 0);
            }
        }
    }
}

