/*
 * Common Library for TBAS Softwares
 * Language: Java
 *
 * All Rights Reserved.
 * Copyright (c) 2003 Tsukuba Bunko.
 *
 * $Id: StringUtilTestCase.java,v 1.1 2003/12/06 14:43:33 ppoi Exp $
 */
package tsukuba_bunko.text.test;

import	junit.framework.TestCase;

import	tsukuba_bunko.text.StringUtil;


/**
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 */
public class StringUtilTestCase extends TestCase {

	/**
	 * Constructor for StringUtilTestCase.
	 * @param arg0
	 */
	public StringUtilTestCase(String arg0) {
		super(arg0);
	}

	public void testTrimString()
	{
		String	text = "hoge";
		assertEquals( "unmatch void string.", text, StringUtil.trimString( "   " + text + " ", false) );
		assertEquals( "unmatch void string.", text, StringUtil.trimString( "   " + text + " ", true) );
	}

	public void testTrimString_VoidString_NotVoidToNull()
	{
		String	text = "";
		assertEquals( "unmatch void string.", text, StringUtil.trimString(text, false) );
	}

	public void testTrimString_VoidString_VoidToNull()
	{
		String	text = "";
		assertSame( "unmatch void string.", null, StringUtil.trimString(text, true) );
	}

	public void testTrimString_SpaceString_NotVoidToNull()
	{
		String	text = "     ";
		assertEquals( "unmatch void string.", "", StringUtil.trimString(text, false) );
	}

	public void testTrimString_SpaceString_VoidToNull()
	{
		String	text = "     ";
		assertSame( "unmatch void string.", null, StringUtil.trimString(text, true) );
	}
}