package tsukuba_bunko.resource.test;

import	java.net.URL;

import	java.util.List;

import	tsukuba_bunko.resource.IllegalResourceException;
import	tsukuba_bunko.resource.Resources;

import	junit.framework.TestCase;


/**
 * <code>ListDeserializer</code> eXg TestCase ł.
 * @author	$Author: ppoi $
 * @see	tsukuba_bunko.resource.ListDeserializer
 */
public class ListDeserializerTestCase	extends TestCase	{

	/**
	 * <code>ListDeserializerTestCase</code> ̃CX^X쐬܂.
	 */
	public ListDeserializerTestCase( String name )
	{
		super( name );
	}


	public void testLoad()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-list.xml" );
		assertNotNull( "resource file not found", resourceURL );

		System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
		Resources	resources = Resources.newInstance( resourceURL );

		List	value = (List)resources.getResource( "tbas.libtbas.resource-manager.test" );
		assertNotNull( "test", value );

		List	comparee = new java.util.ArrayList();
		comparee.add( new Integer(1) );
		comparee.add( new Integer(10) );
		comparee.add( new Integer(100) );
		assertEquals( "test", value, comparee );

		value = (List)resources.getResource( "tbas.libtbas.hoge" );
		assertNotNull( "hoge", value );
		comparee.clear();
		comparee.add( "قP" );
		comparee.add( "قQ" );
		assertEquals( "item2", value, comparee );
	}

	public void testLoadIllegal1()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-list-illegal1.xml" );
		assertNotNull( "resource file not found", resourceURL );

		try	{
			System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
			Resources.newInstance( resourceURL );
			assertTrue( "exception", false );
		}
		catch( IllegalResourceException ire )	{
			System.err.println( "[testLoadIllegal1]" );
			ire.printStackTrace();
		}
	}

	public void testLoadIllegal2()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-list-illegal2.xml" );
		assertNotNull( "resource file not found", resourceURL );

		try	{
			System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
			Resources.newInstance( resourceURL );
			assertTrue( "exception", false );
		}
		catch( IllegalResourceException ire )	{
			System.err.println( "[testLoadIllegal2]" );
			ire.printStackTrace();
		}
	}
}
