package tsukuba_bunko.resource.test;

import	tsukuba_bunko.resource.DeserializerMapping;
import	tsukuba_bunko.resource.NumberDeserializer;
import	tsukuba_bunko.resource.StringDeserializer;
import	tsukuba_bunko.resource.ListDeserializer;
import	tsukuba_bunko.resource.ResourceDeserializer;

import	junit.framework.TestCase;


/**
 * <code>DeserializerMapping</code> eXg TestCase ł.
 * @author	$Author: ppoi $
 * @see	tsukuba_bunko.resource.DeserializerMapping
 */
public class DeserializerMappingTestCase	extends TestCase	{

	/**
	 * <code>DeserializerMappingTestCase</code> ̃CX^X쐬܂.
	 */
	public DeserializerMappingTestCase( String name )
	{
		super( name );
	}


	/**
	 * load() eXg܂.
	 */
	public void testLoad()
	{
		DeserializerMapping	mapping = DeserializerMapping.newInstance();
		assertNotNull( "mapping is null", mapping );
	}


	/**
	 * getResourceDeserializer eXg܂.
	 */
	public void testGetResourceDeserializer()
	{
		DeserializerMapping	mapping = DeserializerMapping.newInstance( "tsukuba_bunko.resource.test.test_mapping" );
		assertNotNull( "mapping is null", mapping );

		ResourceDeserializer	deserializer = mapping.getResourceDeserializer( "integer" );
		assertNotNull( "mapping not found", deserializer );
		assertTrue( "invalid class", (deserializer instanceof NumberDeserializer) );

		deserializer = mapping.getResourceDeserializer( "string" );
		assertNotNull( "mapping not found", deserializer );
		assertTrue( "invalid class", (deserializer instanceof StringDeserializer) );

		deserializer = mapping.getResourceDeserializer( "list/integer" );
		assertNotNull( "mapping not found", deserializer );
		assertTrue( "invalid class", (deserializer instanceof ListDeserializer) );
	}

	/**
	 * getResourceDeserializer eXg܂(ُn).
	 */
	public void testGetResourceDeserializerIllegal()
	{
		DeserializerMapping	mapping = DeserializerMapping.newInstance( "tsukuba_bunko.resource.test.test_mapping" );
		assertNotNull( "mapping is null", mapping );

		ResourceDeserializer	deserializer = mapping.getResourceDeserializer( "not-existed" );
		assertNull( "illegal return", deserializer );
	}
}
