/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SaveDataDialog.java,v 1.1.2.1 2003/12/11 10:12:19 ppoi Exp $
 */
package tsukuba_bunko.peko.session;

import	java.awt.Dimension;
import	java.awt.FlowLayout;
import	java.awt.Rectangle;

import	java.awt.event.ActionEvent;
import	java.awt.event.ActionListener;

import	javax.swing.JButton;
import javax.swing.JDialog;
import	javax.swing.JList;
import	javax.swing.JOptionPane;
import	javax.swing.JPanel;
import	javax.swing.JScrollPane;
import	javax.swing.ListSelectionModel;

import	javax.swing.event.ListSelectionEvent;
import	javax.swing.event.ListSelectionListener;

import	tsukuba_bunko.peko.Logger;
import	tsukuba_bunko.peko.PekoSystem;

import	tsukuba_bunko.peko.resource.ResourceManager;


/**
 * Z[uf[^I_CAOłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SaveDataDialog	extends JDialog	implements ActionListener, ListSelectionListener	{

	/**
	 * _CAO̗prFZ[up
	 */
	public static final boolean	FOR_SAVE = true;

	/**
	 * _CAO̗prF[hp
	 */
	public static final boolean	FOR_LOAD = false;



	/**
	 * Iꂽԍ
	 */
	protected int	_selected = -1;

	/**
	 * \Z[uf[^ꗗ
	 */
	protected SaveDataInfo[]	_infoList = null;


	/**
	 * Z[uf[^ꗗ
	 */
	protected JList	_list = null;

	/**
	 * OK {^
	 */
	protected JButton	_ok = null;

	/**
	 * Cancel {^
	 */
	protected JButton	_cancel = null;

	/**
	 * _CAO̗pr
	 */
	protected boolean _forSave = false;

	/**
	 * Z[uf[^`悷 ListCellRenderer
	 */
	protected SaveDataInfoRenderer	_renderer = null;


	/**
	 * <code>SaveDataDialig</code> ̃CX^X𐶐܂B
	 * @param	forSave	_CAO̗pr
	 */
	public SaveDataDialog( boolean forSave )
	{
		super( PekoSystem.getInstance().getMainWindow(), true );
		_forSave = forSave;

		ResourceManager	resources = ResourceManager.getInstance();
		Boolean	decorated = (Boolean)resources.getResource( ResourceIDs.DIALOG_DECORATED, true );
		if( decorated != null )	{
			setUndecorated( !decorated.booleanValue() );
		}

		if( forSave )	{
			String	title = (String)resources.getResource( ResourceIDs.DIALOG_TITLE_SAVE );
			if( title == null )	{
				Logger.warn( MessageIDs.SAV0012W );
			}
			else	{
				setTitle( title );
			}
		}
		else	{
			String	title = (String)resources.getResource( ResourceIDs.DIALOG_TITLE_LOAD );
			if( title == null )	{
				Logger.warn( MessageIDs.SAV0012W );
			}
			else	{
				setTitle( title );
			}
		}

		_renderer = new SaveDataInfoRenderer();
	}


	/**
	 * <code>SaveDataDialog</code> ̏s܂B
	 * @param	infoList	\Z[uf[^ꗗ
	 */
	protected void initialize( SaveDataInfo[] infoList, int initialIndex )
	{
		ResourceManager	resources = ResourceManager.getInstance();

		JList	list = new JList( infoList );
		list.setAutoscrolls( true );
		list.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
		list.setCellRenderer( _renderer );
		list.addListSelectionListener( this );

		JScrollPane	container = new JScrollPane( list );
		container.setAutoscrolls( true );

		Integer	atonce = (Integer)resources.getResource( ResourceIDs.ITEMS_AT_ONCE );
		if( atonce == null )	{
			atonce = new Integer( 5 );
			Logger.warn( MessageIDs.SAV0013W, new Object[]{"5"} );
		}
		else if( atonce.intValue() <= 0 )	{
			atonce = new Integer( 5 );
			Logger.warn( MessageIDs.SAV0014W, new Object[]{"5"} );
		}
		Dimension	size = container.getPreferredSize();
		Dimension	cellSize = _renderer.getPreferredSize();
		size.height = cellSize.height * atonce.intValue() + 5;
		container.setPreferredSize( size );
		container.setSize( size );

		Rectangle	visibleRect = new Rectangle( 5, (cellSize.height * (initialIndex - 1)), cellSize.width, cellSize.height );
		container.getViewport().scrollRectToVisible( visibleRect );

		JPanel	buttons = new JPanel( new FlowLayout() );
		JButton	ok = new JButton();
		String	caption = (String)resources.getResource( ResourceIDs.BUTTON_OK );
		if( caption == null )	{
			caption = "OK";
			Logger.warn( MessageIDs.SAV0019W, new Object[]{"OK", caption} );
		}
		ok.setText( caption );
		ok.addActionListener( this );
		JButton	cancel = new JButton();
		caption = (String)resources.getResource( ResourceIDs.BUTTON_CANCEL );
		if( caption == null )	{
			caption = "CANCEL";
			Logger.warn( MessageIDs.SAV0019W, new Object[]{"Cancel", caption} );
		}
		cancel.setText( caption );
		cancel.addActionListener( this );
		buttons.add( ok );

		buttons.add( cancel );

		JPanel	cp = new JPanel( new java.awt.BorderLayout() );
		cp.add( container );
		cp.add( buttons, java.awt.BorderLayout.SOUTH );
		setContentPane( cp );

		pack();
		setResizable( false );

		_list = list;
		_ok = ok;
		_cancel = cancel;
		getRootPane().setDefaultButton( _ok );

		_infoList = infoList;
		list.setSelectedIndex( initialIndex );
	}


	/**
	 * ݑIĂZ[uf[^̃CfbNX擾܂B
	 * @return	IĂZ[uf[^̃CfbNX
	 */
	public int getSelectedIndex()
	{
		return _selected;
	}


//
//	ActionListener ̎
//
	public void actionPerformed( ActionEvent ev )
	{
		if( ev.getSource() == _ok )	{
			if( _list.getSelectedValue() == null )	{
				if( _forSave )	{
					_selected = _list.getSelectedIndex();
				}
				else	{
					return;
				}
			}
			else	{
				if( _forSave )	{
					ResourceManager	resources = ResourceManager.getInstance();
					String	title = (String)resources.getResource( ResourceIDs.DIALOG_CONFIRM_TITLE );
					if( title == null )	{
						Logger.warn( MessageIDs.SAV0015W );
					}
					String	message = (String)resources.getResource( ResourceIDs.DIALOG_CONFIRM_MESSAGE );
					if( message == null )	{
						message = "Do you overwrite save data ?";
						Logger.warn( MessageIDs.SAV0016W, new Object[]{"\"" + message + "\""} );
					}

					if( JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(this, message, title, JOptionPane.YES_NO_OPTION) )	{
						_selected = _list.getSelectedIndex();
					}
					else	{
						return;
					}
				}
				else	{
					_selected = _list.getSelectedIndex();
				}
			}
		}
		else	{
			_selected = -1;
		}

		dispose();
	}


//
//	ListSelectionListener ̎
//
	public void valueChanged( ListSelectionEvent ev )
	{
		if( _forSave )	{
			return;
		}

		int	selected = _list.getSelectedIndex();
		if( (selected != -1) && (_infoList[selected] != null) )	{
			_ok.setEnabled( true );
		}
		else	{
			_ok.setEnabled( false );
		}	
	}




//
//	[eBeB
//
	/**
	 * Z[uf[^I_CAO\AIꂽZ[uf[^̃CfbNX擾܂B
	 * @param	list	\Z[uf[^ꗗ
	 * @return	IꂽZ[uf[^̃CfbNX
	 */
	public static int showDialog( SaveDataInfo[] list, int initialIndex, boolean forSave )
	{
		SaveDataDialog	dialog = new SaveDataDialog( forSave );
		dialog.initialize( list, initialIndex );
		dialog.setLocationRelativeTo( dialog.getOwner() );
		dialog.show();
		return dialog.getSelectedIndex();
	}
}
