/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ParagraphHandler.java,v 1.1.2.3 2003/12/19 18:02:19 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.text;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.FlagScope;
import	tsukuba_bunko.peko.scenario.PSMLUtil;

import	tsukuba_bunko.peko.scenario.util.WaitHandler;


/**
 * <samp>p</samp> vf̏s <code>ElementHandler</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.3 $
 */
public class ParagraphHandler	extends TextElementHandler	{

	/**
	 * eLXgobt@
	 */
	private StringBuffer	_text = null;

	/**
	 * ̗vf̕]Iɐݒ肳tO
	 */
	private String	_flagID = null;

	/**
	 * WaitHandler
	 */
	private WaitHandler	_waitHandler = new WaitHandler();


	/**
	 * <code>ParagraphHandler</code> ̃CX^X쐬܂B
	 */
	public ParagraphHandler()
	{
		super();
	}


	/**
	 * pOt\܂B
	 * @return	͂\ꍇ
	 */
	private boolean performParagraph()
	{
		TextCoordinator	coordinator = getTextCoordinator();
		String	paragraph = new String( _text );
		if( paragraph.length() > 0 )	{
			coordinator.pushText( new String(_text) );
			_text = new StringBuffer( 48 );
			return true;
		}
		else	{
			return false;
		}
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		Logger.debug( "[scene] start paragraph" );
		_text = new StringBuffer( 48 );
		_flagID = null;
		getTextCoordinator().begin();
	}

	public void endDocument()
	{
		Logger.debug( "[scene] end paragraph" );
		if( performParagraph() )	{
			stop();
		}
		_text = null;
		getTextCoordinator().commit();

		if( _flagID != null )	{
			getSceneContext().declareFlag( _flagID, FlagScope.SESSION );
		}
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
		throws org.xml.sax.SAXException
	{
		if( localName.equals("wait") )	{
			performParagraph();
			_waitHandler.waitFor( attrs );
		}
		else if( localName.equals("p") )	{
			_flagID = PSMLUtil.getAttributeValue( attrs, "flag" );
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
	{
		//	X^C܂ł͋̂܂܂łB
	}

	public void characters( char[] ch, int begin, int length )
	{
		_text.append( ch, begin, length );
	}
}
