/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: PageConfigurator.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.text;

import	java.awt.Color;
import	java.awt.Dimension;
import	java.awt.Font;
import	java.awt.Insets;
import	java.awt.Point;

import	java.awt.font.TextAttribute;

import	java.util.Map;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.canvas.text.Page;

import	tsukuba_bunko.peko.resource.ColorManager;
import	tsukuba_bunko.peko.resource.DimensionDeserializer;
import	tsukuba_bunko.peko.resource.FontManager;
import	tsukuba_bunko.peko.resource.InsetsDeserializer;
import	tsukuba_bunko.peko.resource.ResourceManager;
import	tsukuba_bunko.peko.resource.PointDeserializer;

import	tsukuba_bunko.peko.scenario.SceneContext;


/**
 * {@link tsukuba_bunko.peko.canvas.text.Page} V[̐ݒɃJX^}CY@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class PageConfigurator	{

	/**
	 * <code>PageConfigurator</code> ̃CX^X쐬邽߂ getInstance Ă΂܂B
	 */
	protected PageConfigurator()
	{
		super();
	}


	/**
	 * y[Wuvɐi߁AV[̏ɊÂď܂B
	 * @param	info	V[
	 */
	public static void configure( Page page, SceneContext context )
	{
		ResourceManager	resources = ResourceManager.getInstance();
		FontManager	fonts = FontManager.getInstance();
		ColorManager	colors = ColorManager.getInstance();

		boolean	set = false;

		String	value = context.getProperty( PropertyIDs.CANVAS_TEXT_BACKGROUND_TRANSPARENCY );
		if( value != null )	{
			try	{
				page.setTransparency( Float.parseFloat(value) );
				set = true;
			}
			catch( Exception e )	{
				Logger.warn( MessageIDs.SCN2006W );
			}
		}
		if( !set )	{
			Float	trans = (Float)resources.getResource( ResourceIDs.CANVAS_TEXT_BACKGROUND_TRANSPARENCY );
			if( trans == null )	{
				Logger.warn( MessageIDs.SCN2005W, new Object[]{"0.5"} );
				page.setTransparency( 0.5f );
			}
			else	{
				page.setTransparency( trans.floatValue() );
			}
		}

		set = false;
		value = context.getProperty( PropertyIDs.CANVAS_TEXT_BACKGROUND_COLOR );
		if( value == null )	{
			Color	c = (Color)resources.getResource( ResourceIDs.CANVAS_TEXT_BACKGROUND_COLOR );
			if( c == null )	{
				Logger.warn( MessageIDs.SCN2003W, new Object[]{"black"} );
				c = Color.black;
			}
			page.setBackground( c );
		}
		else	{
			page.setBackground( colors.getColor(value) );
		}

		String	type = context.getProperty( PropertyIDs.CANVAS_TEXT_VIEWTYPE );
		if( type != null )	{
			if( !"window".equals(type) && !"full".equals(type) )	{
				Logger.warn( MessageIDs.SCN2014W );
				type = null;
			}
		}
		if( type == null )	{
			type = (String)resources.getResource( ResourceIDs.CANVAS_TEXT_VIEWTYPE );
			if( (type == null) || !("window".equals(type) || "full".equals(type)) )	{
				Logger.warn( MessageIDs.SCN2013W, new Object[]{"full"} );
				type = "full";
			}
		}

		Dimension	viewSize = null;
		if( type.equals("window") )	{
			value = context.getProperty( PropertyIDs.CANVAS_TEXT_SIZE );
			if( value != null )	{
				try	{
					viewSize = DimensionDeserializer.parseDimension( value );
				}
				catch( Exception e )	{
					Logger.warn( MessageIDs.SCN2016W );
				}
			}
			if( viewSize == null )	{
				viewSize = (Dimension)resources.getResource( ResourceIDs.CANVAS_TEXT_SIZE );
				if( viewSize == null )	{
					Logger.warn( MessageIDs.SCN2015W, new Object[]{"600, 180"} );
					viewSize = new Dimension( 600, 180 );
				}
			}

			Point	location = null;
			value = context.getProperty( PropertyIDs.CANVAS_TEXT_LOCATION );
			if( value != null )	{
				try	{
					location = PointDeserializer.parsePoint( value );
				}
				catch( Exception e )	{
					Logger.warn( MessageIDs.SCN2018W, e );
				}
			}
			if( location == null )	{
				location = (Point)resources.getResource( ResourceIDs.CANVAS_TEXT_LOCATION );
				if( location == null )	{
					Logger.warn( MessageIDs.SCN2017W, new Object[]{"0, 0"} );
					location = new Point( 0, 0 );
				}
			}

			page.setLocation( location.x, location.y );

		}
		else	{
			page.setLocation( 0, 0 );
			viewSize = page.getTextCanvas().getSize();
		}
		page.setSize( viewSize );

		Insets	padding = null;
		value = context.getProperty( PropertyIDs.CANVAS_TEXT_PADDING );
		if( value != null )	{
			try	{
				padding = InsetsDeserializer.parseInsets( value );
			}
			catch( Exception e )	{
				Logger.warn( MessageIDs.SCN2020W );
			}
		}
		if( padding == null )	{
			padding = (Insets)resources.getResource( ResourceIDs.CANVAS_TEXT_PADDING );
			if( padding == null )	{
				Logger.warn( MessageIDs.SCN2019W, new Object[]{"10,40,10,10"} );
				padding = new Insets( 10, 40, 10, 10 );
			}
		}
		page.setPadding( padding.top, padding.left, padding.bottom, padding.right );


		Map	fontAttrs = new java.util.HashMap( 17 );
		Font	baseFont = (Font)resources.getResource( ResourceIDs.CANVAS_TEXT_FONT );
		if( baseFont == null )	{
			Logger.warn( MessageIDs.SCN2011W, new Object[]{"Serif, 20"} );
			fontAttrs = new java.util.HashMap( 17 );
			fontAttrs.put( TextAttribute.FAMILY, "Serif" );
			fontAttrs.put( TextAttribute.SIZE, new Float(20f) );
			fontAttrs.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
			fontAttrs.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR );
		}
		else	{
			fontAttrs.putAll( baseFont.getAttributes() );
		}

		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FONT_FAMILY );
		if( value != null )	{
			fontAttrs.put( TextAttribute.FAMILY, value );
		}

		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FONT_SIZE );
		if( value != null )	{
			try	{
				fontAttrs.put( TextAttribute.SIZE, Float.valueOf(value) );
			}
			catch( Exception e )	{
				Logger.warn( MessageIDs.SCN2012W, new Object[]{"size"} );
			}
		}

		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FONT_STYLE );
		if( value != null )	{
			if( "italic".equals(value) )	{
				fontAttrs.put( TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE );
			}
			else if( "normal".equals(value) )	{
				fontAttrs.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
			}
			else	{
				Logger.warn( MessageIDs.SCN2012W, new Object[]{"style"} );
			}
		}

		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FONT_WEIGHT );
		if( value != null )	{
			if( "bold".equals(value) )	{
				fontAttrs.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD );
			}
			else if( "normal".equals(value) )	{
				fontAttrs.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR );
			}
		}

		page.setDefaultFont( fonts.getFont(fontAttrs) );


		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FOREGROUND_COLOR );
		if( value == null )	{
			Color	c = (Color)resources.getResource( ResourceIDs.CANVAS_TEXT_FOREGROUND_COLOR );
			if( c == null )	{
				Logger.warn( MessageIDs.SCN2007W, new Object[]{"white"} );
				c = Color.white;
			}
			page.setForeground( c );
		}
		else	{
			page.setForeground( colors.getColor(value) );
		}

		value = context.getProperty( PropertyIDs.CANVAS_TEXT_FOREGROUND_SHADOW );
		if( value == null )	{
			Color	c = (Color)resources.getResource( ResourceIDs.CANVAS_TEXT_FOREGROUND_SHADOW );
			if( c == null )	{
				Logger.warn( MessageIDs.SCN2007W, new Object[]{"black"} );
				c = Color.black;
			}
			page.setShadow( c );
		}
		else	{
			page.setShadow( colors.getColor(value) );
		}

		page.updateCanvas();
	}
}
