/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: HeadHandler.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.structure;

import	java.io.InputStream;

import	java.net.URL;

import	java.util.Iterator;
import	java.util.Properties;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;
import	tsukuba_bunko.peko.PekoSystem;

import	tsukuba_bunko.peko.resource.ResourceManager;


import tsukuba_bunko.peko.scenario.ElementHandler;
import	tsukuba_bunko.peko.scenario.NextSceneMapping;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.SceneContext;


/**
 * <samp>head</samp> vf ElementHandler łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class HeadHandler extends ElementHandler {

	/**
	 * LbV
	 */
	protected StringBuffer	_text = null;

	/**
	 * Jڐ\
	 */
	protected NextSceneMapping	_nextSceneMapping = null;

	/**
	 */
	protected String	_condition = null;


	/**
	 * <code>HeadHandler</code> ̃CX^X𐶐܂B
	 */
	public HeadHandler()
	{
		super();
	}


//
//	ElementHandler ̎
//
	public void endDocument()
	{
		SceneContext	context = getSceneContext();
		if( context.getSceneTitle() == null )	{
			Logger.warn( MessageIDs.SCN5001W );
			context.setSceneTitle( context.getSceneName() );
		}
		ResourceManager	resources = ResourceManager.getInstance();
		PekoSystem.getInstance().getMainWindow().setTitle( context.getSceneTitle() + " - " + resources.getResource("game-info.title") );
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		if( localName.equals("property") )	{
			String	name = PSMLUtil.getAttributeValue( attrs, "name" );
			String	file = PSMLUtil.getAttributeValue( attrs, "file" );
			if( (name != null) && (name.length() > 0) )	{
				getSceneContext().setProperty( name, PSMLUtil.getAttributeValue(attrs, "value") );
			}
			else if( (file != null) && (file.length() > 0) )	{
				ResourceManager	resources = ResourceManager.getInstance();
				URL	sceneDir = resources.getLocationResources().getScenesDirecotryURL();
				URL	fileURL = null;
				try	{
					fileURL = new URL( sceneDir, file );
				}
				catch( Exception e )	{
					Logger.warn( MessageIDs.SCN5002W, new Object[]{getSceneContext().getCurrentPath()}, e );
					return;
				}

				Properties	properties = new Properties();
				InputStream	is = null;
				try	{
					is = fileURL.openStream();
					properties.load( is );
				}
				catch( Exception e )	{
					Logger.warn( MessageIDs.SCN5002W, new Object[]{getSceneContext().getCurrentPath()}, e );
					return;
				}
				finally	{
					if( is != null )	{
						try	{
							is.close();
						}
						catch( Exception e )	{
						}
					}
				}

				SceneContext	context = getSceneContext();
				Iterator	itr = properties.keySet().iterator();
				String	key = null;
				while( itr.hasNext() )	{
					key = (String)itr.next();
					context.setProperty( key, properties.getProperty(key) );
				}
			}
		}
		else if( "next-scene".equals(localName) )	{
			_nextSceneMapping = getSceneContext().getNextSceneMapping();
		}
		else if( localName.equals("title") )	{
			_text = new StringBuffer();
		}
		else if( localName.equals("scene-ref") )	{
			_text = new StringBuffer();
			_condition = PSMLUtil.getAttributeValue( attrs, "if" );
			if( _condition != null )	{
				_condition = _condition.trim();
			}
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
	{
		if( localName.equals("title") )	{
			if( _text.length() == 0 )	{
				Logger.warn( MessageIDs.SCN5001W );
				getSceneContext().setSceneTitle( getSceneContext().getSceneName() );
			}
			else	{
				getSceneContext().setSceneTitle( new String(_text) );
			}
		}
		else if( localName.equals("scene-ref") )	{
			if( _text.length() > 0 )	{
				NextSceneMapping	mapping = getSceneContext().getNextSceneMapping();
				String	sceneName = new String(_text).trim();
				if( (_condition == null) || (_condition.length() == 0) )	{
					mapping.setDefaultSceneMapping( sceneName );
				}
				else	{
					mapping.addNextSceneMapping( _condition, sceneName );
				}
				_condition = null;
			}
		}
		else if( localName.equals("next-scene") )	{
			_nextSceneMapping = null;
		}
		_text = null;
	}

	public void characters( char[] ch, int begin, int length )
	{
		if( _text != null )	{
			_text.append( ch, begin, length );
		}
	}
}
