/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SoundHandler.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.stage;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>start-bgm</samp>, <samp>stop-bgm</samp>, <samp>start-se</samp>,
 * <samp>stop-se</samp> vf <code>ElementHandler</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SoundHandler	extends StageElementHandler	{

	/**
	 * <code>SoundHandler</code> ̃CX^X쐬܂B
	 */
	public SoundHandler()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
	}

	public void endDocument()
	{
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		String	id = PSMLUtil.getAttributeValue( attrs, "id" );
		if( id == null )	{
			Logger.error( MessageIDs.SCN3003E, new Object[]{getSceneContext().getCurrentPath()} );
			return;
		}

		String	clipName = null;
		String	loop = null;
		boolean	lp = false;

		StageCoordinator	coordinator = getStageCoordinator();
		if( "play-bgm".equals(localName) )	{
			clipName = PSMLUtil.getAttributeValue( attrs, "clip" );
			if( clipName == null )	{
				Logger.warn( MessageIDs.SCN3004W, new Object[]{getSceneContext().getCurrentPath()} );
				return;
			}

			loop = PSMLUtil.getAttributeValue( attrs, "loop" );
			if( loop != null )	{
				lp = (loop.equalsIgnoreCase("true") || loop.equalsIgnoreCase("yes") || loop.equalsIgnoreCase("on"));
			}
			else	{
				lp = true;
			}

			coordinator.playBGM( id, clipName, lp );
		}
		else if( "play-se".equals(localName) )	{
			clipName = PSMLUtil.getAttributeValue( attrs, "clip" );
			if( clipName == null )	{
				Logger.warn( MessageIDs.SCN3004W, new Object[]{getSceneContext().getCurrentPath()} );
				return;
			}

			loop = PSMLUtil.getAttributeValue( attrs, "loop" );
			if( loop != null )	{
				lp = (loop.equalsIgnoreCase("true") || loop.equalsIgnoreCase("yes") || loop.equalsIgnoreCase("on"));
			}
			else	{
				lp = false;
			}

			coordinator.playSE( id, clipName, lp );
		}
		else if( "stop-bgm".equals(localName) )	{
			coordinator.stopBGM( id );
		}
		else if( "stop-se".equals(localName) )	{
			coordinator.stopSE( id );
		}
	}
}
