/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: NextSceneMapping.java,v 1.1.2.1 2003/12/11 10:13:38 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario;

import	java.io.Serializable;

import	java.util.Iterator;
import	java.util.List;
import	java.util.Map;

import	tsukuba_bunko.peko.Logger;


/**
 * @author	${Author}$
 * @version	${Revision}$
 */
public class NextSceneMapping	implements Serializable	{

	/**
	 * ]̏
	 */
	private List	_conditionList = new java.util.ArrayList();

	/**
	 * V[Jڐ\
	 */
	private Map	_nextScenes = new java.util.HashMap();


	/**
	 * <code>NextSceneMapping</code> ̃CX^X𐶐܂B
	 */
	public NextSceneMapping()
	{
	}


	public void addNextSceneMapping( String condition, String nextScene )
	{
		if( _conditionList.contains(condition) )	{
			Logger.warn( MessageIDs.SCN0010W, new Object[]{condition, _nextScenes.get(condition), nextScene} );
		}
		else	{
			_conditionList.add( condition );
			_nextScenes.put( condition, nextScene );
		}
	}

	public void setDefaultSceneMapping( String nextScene )
	{
		setDefaultSceneMapping( nextScene, true );
	}

	public void setDefaultSceneMapping( String nextScene, boolean warn )
	{
		if( _nextScenes.containsKey(null) && warn )	{
			Logger.warn( MessageIDs.SCN0010W, new Object[]{"_default_", _nextScenes.get(null), nextScene} );
		}
		else	{
			_nextScenes.put( null, nextScene );
		}
	}

	public String getNextScene( SceneContext context )
	{
		Iterator	itr = _conditionList.iterator();
		String	condition = null;
		while( itr.hasNext() )	{
			condition = (String)itr.next();
			if( PSMLUtil.isEvaluatable(condition, context) )	{
				return (String)_nextScenes.get( condition );
			}
		}
		return (String)_nextScenes.get( null );
	}
}