/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: HandlerRegistry.java,v 1.1.2.1 2003/12/11 10:13:39 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario;

import	java.util.Map;


import	tsukuba_bunko.peko.scenario.select.SelectHandler;

import	tsukuba_bunko.peko.scenario.stage.ActorHandler;
import	tsukuba_bunko.peko.scenario.stage.AtOnceHandler;
import	tsukuba_bunko.peko.scenario.stage.BackgroundHandler;
import	tsukuba_bunko.peko.scenario.stage.SlideHandler;
import	tsukuba_bunko.peko.scenario.stage.SoundHandler;

import	tsukuba_bunko.peko.scenario.structure.HeadHandler;

import	tsukuba_bunko.peko.scenario.text.NewPageHandler;
import	tsukuba_bunko.peko.scenario.text.ParagraphHandler;

import	tsukuba_bunko.peko.scenario.util.FlagHandler;
import	tsukuba_bunko.peko.scenario.util.SceneFlowHandler;
import	tsukuba_bunko.peko.scenario.util.WaitHandler;


/**
 * vf ElementHandler ̊֘AÂǗ܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class HandlerRegistry	{

	/**
	 * handler registries per namespace
	 */
	private Map	_registry = new java.util.HashMap( 89 );


	/**
	 * <code>HandlerRegistry</code> ̃CX^X쐬܂B
	 */
	public HandlerRegistry()
	{
		super();
	}

	/**
	 * w肳ꂽvfɑ΂ ElementHandler ֘AÂ܂B
	 * @param	elementName	vf
	 * @param	handler	֘AÂ ElementHandler
	 */
	public void register( String elementName, ElementHandler handler )
	{
		register( ElementHandler.NAMESPACE_SCENE, elementName, handler );
	}

	/**
	 * w肳ꂽvfɑ΂ ElementHandler ֘AÂ܂B
	 * @param	namespaceURI	XML l[Xy[X URI
	 * @param	localName	vf
	 * @param	handler	֘AÂ ElementHandler
	 */
	public void register( String namespaceURI, String localName, ElementHandler handler )
	{
		Map	handlers = getElementHandlers( namespaceURI );
		handlers.put( localName, handler );
	}

	/**
	 * w肳ꂽvfɑ΂֘AÂ폜܂B
	 * @param	localName	vf
	 */
	public void unregister( String elementName )
	{
		unregister( ElementHandler.NAMESPACE_SCENE, elementName );
	}

	/**
	 * w肳ꂽvfɑ΂֘AÂ폜܂B
	 * @param	namespaceURI	vf̃l[Xy[X URI
	 * @param	localName	vf
	 */
	public void unregister( String namespaceURI, String localName )
	{
		Map	handlers = getElementHandlers( namespaceURI );
		handlers.remove( localName );
	}

	/**
	 * w肳ꂽvfɊ֘AÂꂽ ElementHandler 擾܂B
	 * @param	elementName	vf
	 * @return	֘AÂꂽ ElementHandlerB֘AÂ݂Ȃꍇ <code>null</code>
	 */
	public ElementHandler getElementHandler( String elementName )
	{
		return getElementHandler( ElementHandler.NAMESPACE_SCENE, elementName );
	}

	/**
	 * w肳ꂽvfɊ֘AÂꂽ ElementHandler 擾܂B
	 * @param	namespaceURI	vf̃l[Xy[X URI
	 * @param	localName	vf
	 * @return	֘AÂꂽ ElementHandlerB֘AÂ݂Ȃꍇ <code>null</code>
	 */
	public ElementHandler getElementHandler( String namespaceURI, String localName )
	{
		Map	handlers = getElementHandlers( namespaceURI );
		return (ElementHandler)handlers.get( localName );
	}

	/**
	 * w肳ꂽl[Xy[Xp ElementHandler }bv擾܂B
	 * @param	namespaceURI	l[Xy[X URI
	 * @return	ElementHandler }bv
	 */
	private Map getElementHandlers( String namespaceURI )
	{
		Map	handlers = (Map)_registry.get( namespaceURI );
		if( handlers == null )	{
			handlers = new java.util.HashMap( 89 );
			_registry.put( namespaceURI, handlers );
		}
		return handlers;
	}



	/**
	 * <code>HandlerRegistry</code> ̐VCX^X𐶐܂B
	 */
	public static HandlerRegistry newInstance()
	{
		HandlerRegistry	instance = new HandlerRegistry();

		instance.register( ElementHandler.NAMESPACE_SCENE, "select", new SelectHandler() );

		instance.register( ElementHandler.NAMESPACE_SCENE, "flag", new FlagHandler() );
		instance.register( ElementHandler.NAMESPACE_SCENE, "wait", new WaitHandler() );
		instance.register( ElementHandler.NAMESPACE_SCENE, "scene-flow", new SceneFlowHandler() );

		instance.register( ElementHandler.NAMESPACE_SCENE, "np", new NewPageHandler() );
		instance.register( ElementHandler.NAMESPACE_SCENE, "p", new ParagraphHandler() );

		instance.register( ElementHandler.NAMESPACE_SCENE, "head", new HeadHandler() );

		ActorHandler	actorHandler = new ActorHandler();
		instance.register( ElementHandler.NAMESPACE_SCENE, "enter", actorHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "action", actorHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "exit", actorHandler );

		instance.register( ElementHandler.NAMESPACE_SCENE, "background", new BackgroundHandler() );

		SlideHandler	slideHandler = new SlideHandler();
		instance.register( ElementHandler.NAMESPACE_SCENE, "show-slide", slideHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "hide-slide", slideHandler );

		instance.register( ElementHandler.NAMESPACE_SCENE, "at-once", new AtOnceHandler() );

		SoundHandler	soundHandler = new SoundHandler();
		instance.register( ElementHandler.NAMESPACE_SCENE, "play-bgm", soundHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "stop-bgm", soundHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "play-se", soundHandler );
		instance.register( ElementHandler.NAMESPACE_SCENE, "stop-se", soundHandler );

		return instance;
	}
}