/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: IconDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.net.URL;

import	javax.swing.ImageIcon;

import	org.xml.sax.SAXException;

import	tsukuba_bunko.resource.SimpleDeserializer;


/**
 * {@link javax.swing.ImageIcon} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:icon">peko:icon ^̃\[X</a>
 */
public class IconDeserializer	extends SimpleDeserializer	{

	/**
	 * x[X URL
	 */
	private URL	_baseURL = null;


	/**
	 * <code>IconDeserializer</code> ̃CX^X쐬܂B
	 */
	public IconDeserializer()
	{
		super();
	}


	/**
	 * x[X URL ݒ肵܂.
	 * @param	baseURL	x[X URL
	 */
	public void setBaseURL( URL baseURL )
	{
		_baseURL = baseURL;
	}


//
//	SimpleDeserializer ̎
//
	public Object convertValue( String source )
		throws SAXException
	{
		try	{
			if( _baseURL != null )	{
				return new ImageIcon( new URL(_baseURL, source) );
			}
			else	{
				return new ImageIcon( source );
			}
		}
		catch( Exception e )	{
			throw new SAXException( e );
		}
	}
}
