/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: MofingEffect.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage.effect;

import	java.awt.AlphaComposite;
import	java.awt.Graphics2D;

import	java.awt.image.BufferedImage;
import	java.awt.image.ImageObserver;

import	tsukuba_bunko.peko.canvas.stage.Effect;


/**
 * "[tBO" GtFNgłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class MofingEffect	extends Effect	{

	/**
	 * alpha-composites
	 */
	private static AlphaComposite[]	_composites = new AlphaComposite[5];
	static	{
		_composites[4] = AlphaComposite.SrcOver;
		_composites[3] = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.8f );
		_composites[2] = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.4f );
		_composites[1] = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.2f );
		_composites[0] = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.1f );
	}


	/**
	 * <code>MofingEffect</code> ̃CX^X쐬܂B
	 */
	public MofingEffect()
	{
		super();
	}


	/**
	 * GtFNg "mofing" 擾܂B
	 * @return	GtFNg
	 */
	public String getName()
	{
		return "mofing";
	}


	/**
	 */
	protected void perform( BufferedImage screen, BufferedImage next )
	{
		ImageObserver	observer = getStageCanvas();

		Graphics2D	g2 = screen.createGraphics();
		AlphaComposite[]	composites = _composites;
		int	size = composites.length;
		for( int i = 0; i < size; ++i )	{
			g2.setComposite( composites[i] );
			g2.drawImage( next, 0, 0, observer );
			drawImage( screen );
		}
	}
}
