/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Effect.java,v 1.1.2.1 2003/12/11 10:23:10 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.stage;

import	java.awt.Dimension;
import	java.awt.Image;

import	java.awt.image.BufferedImage;


/**
 * GtFNgsNX̊{NXłB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public abstract class Effect	{

	/**
	 * LoX
	 */
	private StageCanvas	_canvas = null;

	/**
	 * TCYLbV
	 */
	private Dimension	_size = new Dimension();


	/**
	 * <code>Effect</code> ̃CX^X쐬邽߂ɃTuNX̃RXgN^Ă΂܂B
	 */
	protected Effect()
	{
		super();
	}


	/**
	 * ܂B
	 */
	public void initialize()
	{
		_canvas = null;
	}

	/**
	 * ItXN[obt@`悷Xe[WLoX擾܂B
	 * @return	Xe[WLoX
	 */
	protected StageCanvas getStageCanvas()
	{
		return _canvas;
	}

	/**
	 * Xe[WLoX̃TCY擾܂B
	 * @return	TCYi[ Dimension CX^X
	 */
	protected Dimension getCanvasSize()
	{
		return _canvas.getSize( _size );
	}

	/**
	 * <code>screen</code> LoXɕ`悵܂B
	 */
	protected void drawImage( Image screen )
	{
//		_g.drawImage( screen, 0, 0, _canvas );
		_canvas.repaint();
	}

	/**
	 * s菇̃ev[g\bhłB
	 * @param	canvas	ItXN[obt@`悷LoX
	 * @param	screen	ItXN[obt@
	 * @param	next	Rs[摜
	 */
	public final void process( StageCanvas canvas, BufferedImage screen, BufferedImage next )
	{
		_canvas = canvas;
		perform( screen, next );
		initialize();
	}

	/**
	 *  <code>Effect</code> ̖O擾܂B
	 * @return	GtFNg
	 */
	public abstract String getName();

	/**
	 * <code>next</code> ̓eGtFNgȂ <code>screen</code> ɃRs[܂B
	 * @param	screen	ItXN[obt@
	 * @param	next	Rs[摜
	 */
	protected abstract void perform( BufferedImage screen, BufferedImage next );
}
