/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ActionControler.java,v 1.1.2.5 2003/12/29 16:48:33 ppoi Exp $
 */
package tsukuba_bunko.peko;

import	java.awt.event.ActionListener;
import	java.awt.event.MouseEvent;
import	java.awt.event.MouseListener;
import	java.awt.event.KeyEvent;
import	java.awt.event.KeyListener;
import	java.awt.event.WindowListener;

import	java.text.MessageFormat;

import	java.util.Timer;
import	java.util.TimerTask;

import	javax.swing.ButtonGroup;
import	javax.swing.ImageIcon;
import	javax.swing.JButton;
import	javax.swing.JCheckBoxMenuItem;
import	javax.swing.JDialog;
import	javax.swing.JFrame;
import	javax.swing.JMenu;
import	javax.swing.JMenuBar;
import	javax.swing.JMenuItem;
import	javax.swing.JOptionPane;
import	javax.swing.JRadioButtonMenuItem;
import	javax.swing.KeyStroke;

import	tsukuba_bunko.util.GenericListener;

import	tsukuba_bunko.peko.canvas.CanvasManager;

import	tsukuba_bunko.peko.resource.ResourceManager;


/**
 * vC[̑󂯕tRg[łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.5 $
 */
public class ActionControler	implements KeyListener, MouseListener	{

	/**
	 * vC[삷܂Œ~Xgbv[h(ftHg)
	 */
	public static final long	SM_DEFAULT = -1;

	/**
	 * mXgbv[h
	 */
	public static final long	SM_NONSTOP = 0;


	/**
	 * vC(̑I܂ŃXLbv)[h
	 */
	public static final int	PM_SKIP = 1;

	/**
	 * ʏvC[h
	 */
	public static final int PM_NORMAL = 0;

	/**
	 * vC[h
	 */
	public static final int	PM_AUTOMATIC = 2;


	/**
	 */
	private Object	_lock = this;

	/**
	 * Lǂ
	 */
	private boolean	_activity = false;

	/**
	 * vC[h
	 */
	private int	_playMode = -1;

	/**
	 * vC[hύX{^(j[)Xg
	 */
	private JMenuItem[]	_buttons = new JMenuItem[3];

	/**
	 * GtFNggpȂj[
	 */
	private JMenuItem	_usingEffectMenu = null;

	/**
	 * Z[uj[
	 */
	private JMenuItem	_saveMenu = null;

	/**
	 * [hj[
	 */
	private JMenuItem	_loadMenu = null;

	/**
	 * ^Cgɖ߂郁j[
	 */
	private JMenuItem	_returnTileMenu = null;

	/**
	 * ߋ̓̕j[
	 */
	private JMenuItem	_readAgainMenu = null;

	/**
	 * ^C}[
	 */
	private Timer	_timer = new Timer( true );

	/**
	 * ŐṼ^XN
	 */
	private TimerTask	_lastTask = null;


	/**
	 * ǂݕԂRg[
	 */
	private TextHistoryControler	_readAgainControler = null;

	/**
	 * ŌɉꂽL[̃L[R[h
	 */
	private int	_lastKeyCode = -1;

	/**
	 * active ҂ǂ
	 */
	private boolean	_waitingActivate = false;

	/**
	 * eLXgBĂ邩ǂ
	 */
	private boolean	_hiddenText = false;


	/**
	 * <code>ActionControler</code> ̃CX^X쐬܂B
	 */
	public ActionControler()
	{
		super();
		prepareMenuBar();
		setPlayModeToNormal();
	}

	/**
	 * ActionContorler Lɂ邩ǂݒ肵܂B
	 * @param	activity	Lɂꍇ <code>false</code>AȊO <code>false</code>B
	 */
	public void setActive( boolean activity )
	{
		_activity = activity;
		if( !activity )	{
			_lastKeyCode = -1;
		}
		else if( _playMode != ActionControler.PM_NORMAL )	{
			if( _waitingActivate )	{
				synchronized( _lock )	{
					if( _waitingActivate )	{
						_lock.notify();
					}
				}
			}
		}
	}

	/**
	 * ActionControler Lǂ𔻒肵܂B
	 * @return	Lȏꍇ <code>true</code>AȊO <code>false</code>B
	 */
	public boolean isActive()
	{
		return _activity && !PekoSystem.getInstance().getCanvasManager().isShowingSelect();
	}

	/**
	 * Z[u@\̗L^ݒ肵܂B
	 * @param	enabled	Lɂꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public synchronized void setSaveEnabled( boolean enabled )
	{
		_saveMenu.setEnabled( enabled );
	}

	/**
	 * ݂̃vC[h擾܂B
	 */
	public int getPlayMode()
	{
		return _playMode;
	}

	/**
	 * vC[hݒ肵܂B
	 * @param	playMode	vC[hB<code>PM_FORWARD</code>A<code>PM_NORMAL</code>A<code>PM_AUTOMATIC</code> IB
	 */
	protected void setPlayMode( int playMode )
	{
		_playMode = playMode;
		_buttons[playMode].setSelected( true );
		if( playMode == ActionControler.PM_SKIP )	{
			_readAgainMenu.setEnabled( false );
		}
		else if( !_readAgainMenu.isEnabled() )	{
			_readAgainMenu.setEnabled( true );
		}
		PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect( !_usingEffectMenu.isSelected() && (playMode != ActionControler.PM_SKIP) );
		if( (_playMode != ActionControler.PM_NORMAL) && !PekoSystem.getInstance().getCanvasManager().isShowingSelect() )	{
			start();
		}
	}

	/**
	 * vC[huvɐݒ肵܂B
	 */
	public void setPlayModeToSKip()
	{
		setPlayMode( ActionControler.PM_SKIP );
	}

	/**
	 * vC[huʏvɐݒ肵܂B
	 */
	public void setPlayModeToNormal()
	{
		setPlayMode( ActionControler.PM_NORMAL );
	}

	/**
	 * vC[huvɐݒ肵܂B
	 */
	public void setPlayModeToAutomatic()
	{
		setPlayMode( ActionControler.PM_AUTOMATIC );
	}

	/**
	 * 摜؂ւGtFNggp邩ǂ؂ւ܂B
	 */
	public void changeUsingEffect()
	{
		PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect( !_usingEffectMenu.isSelected() && (_playMode != ActionControler.PM_SKIP) );
	}

	/**
	 * ǂݕԂRg[\܂B
	 */
	public void showReadAgain()
	{
		setActive( false );
		_saveMenu.setEnabled( false );
		_loadMenu.setEnabled( false );
		_returnTileMenu.setEnabled( false );
		_readAgainMenu.setEnabled( false );
		if( _readAgainControler == null )	{
			_readAgainControler = new TextHistoryControler();
			_readAgainControler.setLocationRelativeTo( PekoSystem.getInstance().getMainWindow() );
		}
		_readAgainControler.show();
		setActive( true );
		_saveMenu.setEnabled( true );
		_loadMenu.setEnabled( true );
		_returnTileMenu.setEnabled( true );
		_readAgainMenu.setEnabled( true );
	}

	/**
	 * [h_CAO\܂B
	 */
	public void showLoadDialog()
	{
		setActive( false );
		_saveMenu.setEnabled( false );
		_loadMenu.setEnabled( false );
		_returnTileMenu.setEnabled( false );
		_readAgainMenu.setEnabled( false );
		PekoSystem	system = PekoSystem.getInstance();
		if( !system.load() )	{
			setActive( true );
		}
		_saveMenu.setEnabled( true );
		_loadMenu.setEnabled( true );
		_returnTileMenu.setEnabled( true );
		_readAgainMenu.setEnabled( true );
	}

	/**
	 * Z[u_CAO\܂B
	 */
	public synchronized void showSaveDialog()
	{
		PekoSystem	system = PekoSystem.getInstance();
		setActive( false );
		_saveMenu.setEnabled( false );
		_loadMenu.setEnabled( false );
		_returnTileMenu.setEnabled( false );
		_readAgainMenu.setEnabled( false );
		system.save();
		_saveMenu.setEnabled( true );
		_loadMenu.setEnabled( true );
		_returnTileMenu.setEnabled( true );
		_readAgainMenu.setEnabled( true );
		setActive( true );
	}

	/**
	 * ^Cgʂɖ߂܂B
	 */
	public void returnTitle()
	{
		returnTitle( false );
	}

	/**
	 * ^Cgʂɖ߂܂B
	 */
	public void returnTitle( boolean silence )
	{
		setActive( false );
		setPlayMode( ActionControler.PM_NORMAL );
		_saveMenu.setEnabled( false );
		_loadMenu.setEnabled( false );
		_returnTileMenu.setEnabled( false );
		_readAgainMenu.setEnabled( false );
		if( silence )	{
			PekoSystem.getInstance().showTitle();
		}
		else	{
			ResourceManager	resources = ResourceManager.getInstance();
			String	message = (String)resources.getResource( "peko.dialog.return-title.message" );
			if( message == null )	{
				message = "Are you return title ?";
			}

			String	title = (String)resources.getResource( "peko.dialog.return-title.title" );
			if( title == null )	{
				title = "Confirm";
			}

			if( JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(PekoSystem.getInstance().getMainWindow(), message, title, JOptionPane.OK_CANCEL_OPTION) )	{
				PekoSystem.getInstance().showTitle();
			}
			else	{
				setActive( true );
			}
		}
		_saveMenu.setEnabled( true );
		_loadMenu.setEnabled( true );
		_returnTileMenu.setEnabled( true );
		_readAgainMenu.setEnabled( true );
	}


	/**
	 * {@link #stop()} ɂ~ꂽXbhĊJ܂B
	 */
	public void start()
	{
		synchronized( _lock )	{
			if( _lastTask != null )	{
				_lastTask.cancel();
			}
			_lastTask = null;
			_lock.notify();
			Logger.debug( "[system.controler] notify to finish wait." );
		}
	}

	/**
	 * vC[ANVN܂Ō݂̃Xbh~܂B
	 */
	public void stop()
	{
		stop( ActionControler.SM_DEFAULT );
	}

	/**
	 * ݂̃Xbh~܂B
	 * @param	wait	҂ԁBvC[삷܂ŃXgbvꍇ <code>SM_DEFAULT</code> A~̏ꍇ <code>SM_NONSTOP</code> w肷B
	 */
	public void stop( long wait )
	{
		Logger.debug( "[system.controler] stop :" + wait );
		if( (wait == 0) || (_playMode == ActionControler.PM_SKIP) )	{
			//NOOP
		}
		else if( wait < 0 )	{
			synchronized( _lock )	{
				try	{
					if( (_playMode == ActionControler.PM_AUTOMATIC) && !PekoSystem.getInstance().getCanvasManager().isShowingSelect() )	{
						TimerTask	task = new TimerTask()	{
							public void run()	{
								synchronized( _lock )	{
									_lock.notify();
								}
							}
						};
						_timer.schedule( task, 1000L );
						_lastTask = task;
					}
					_lock.wait();
				}
				catch( InterruptedException ie )	{
					Logger.debug( "[system.action] interrupted." );
				}
			}
		}
		else	{
			synchronized( _lock )	{
				try	{
					TimerTask	task = new TimerTask()	{
						public void run()	{
							synchronized( _lock )	{
								_lock.notify();
							}
						}
					};
					_timer.schedule( task, wait );
					_lastTask = task;
					_lock.wait();
				}
				catch( InterruptedException ie )	{
					Logger.debug( "[system.action] interrupted." );
				}
			}
		}

		if( !isActive() && (_lastTask != null) )	{
			synchronized( _lock )	{
				if( !_activity && (_lastTask != null) )	{
					_waitingActivate = true;
					try	{
						_lock.wait();
						_lock.wait( 500 );
					}
					catch( InterruptedException ie )	{
					}
					_waitingActivate = false;
				}
			}
		}

		_lastTask = null;
		Logger.debug( "[system.controler] finish wait." );
	}


	/**
	 * j[o[܂B
	 */
	private void prepareMenuBar()
	{
		PekoSystem	system = PekoSystem.getInstance();
		ResourceManager	resources = ResourceManager.getInstance();

		JMenuBar	menubar = new JMenuBar();
		JMenu	menu = null;
		JMenuItem	item = null;

		menu = new JMenu( (String)resources.getResource("peko.menu.system.menu-caption") );
		menu.setMnemonic( 'S' );
		menubar.add( menu );

		item = new JMenuItem( (String)resources.getResource("peko.menu.system.save") );
		item.setEnabled( false );
		item.setMnemonic( 'S' );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_S, KeyEvent.CTRL_MASK) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "showSaveDialog", true );
		menu.add( item );
		_saveMenu = item;

		item = new JMenuItem( (String)resources.getResource("peko.menu.system.load") );
		item.setEnabled( false );
		item.setMnemonic( 'O' );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_O, KeyEvent.CTRL_MASK) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "showLoadDialog", true );
		menu.add( item );
		_loadMenu = item;

		menu.addSeparator();

		item = new JMenuItem( (String)resources.getResource("peko.menu.system.return-title") );
		item.setEnabled( false );
		item.setMnemonic( 'T' );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_T, KeyEvent.CTRL_MASK) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "returnTitle", true );
		menu.add( item );
		_returnTileMenu = item;

		item = new JMenuItem( (String)resources.getResource("peko.menu.system.read-again") );
		item.setEnabled( false );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_R, 0) );
		item.setMnemonic( 'R' );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "showReadAgain" );
		menu.add( item );
		_readAgainMenu = item;

		menu.addSeparator();

		item = new JMenuItem( (String)resources.getResource("peko.menu.system.exit") );
		item.setMnemonic( 'X' );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_Q, KeyEvent.CTRL_MASK) );
		GenericListener.connect( item, system, ActionListener.class, "actionPerformed", "exit" );
		menu.add( item );


		menu = new JMenu( (String)resources.getResource("peko.menu.config.menu-caption") );
		menu.setMnemonic( 'C' );
		menubar.add( menu );

		JMenu	submenu = new JMenu( (String)resources.getResource("peko.menu.config.playmode.menu-caption") );
		submenu.setMnemonic( 'P' );
		menu.add( submenu );

		ButtonGroup	group = new ButtonGroup();
		item = new JRadioButtonMenuItem( (String)resources.getResource("peko.menu.config.playmode.normal") );
		item.setMnemonic( 'N' );
//		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_N, KeyEvent.CTRL_MASK | KeyEvent.SHIFT_MASK) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "setPlayModeToNormal" );
		group.add( item );
		submenu.add( item );
		_buttons[ ActionControler.PM_NORMAL ] = item;

		item = new JRadioButtonMenuItem( (String)resources.getResource("peko.menu.config.playmode.automatic") );
		item.setMnemonic( 'A' );
//		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_A, KeyEvent.CTRL_MASK | KeyEvent.SHIFT_MASK) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "setPlayModeToAutomatic" );
		group.add( item );
		submenu.add( item );
		_buttons[ ActionControler.PM_AUTOMATIC ] = item;

		item = new JRadioButtonMenuItem( (String)resources.getResource("peko.menu.config.playmode.skip") );
		item.setMnemonic( 'S' );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_S, 0) );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "setPlayModeToSKip" );
		group.add( item );
		submenu.add( item );
		_buttons[ ActionControler.PM_SKIP ] = item;

		menu.addSeparator();

		item = new JCheckBoxMenuItem( (String)resources.getResource("peko.menu.config.use-effect") );
		item.setSelected( false );
		item.setMnemonic( 'E' );
		GenericListener.connect( item, this, ActionListener.class, "actionPerformed", "changeUsingEffect" );
		menu.add( item );
		_usingEffectMenu = item;


		menu = new JMenu( (String)resources.getResource("peko.menu.help.menu-caption") );
		menu.setMnemonic( 'H' );
		menubar.add( menu );

		item = new JMenuItem( (String)resources.getResource("peko.menu.help.help-contents") );
		item.setAccelerator( KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0) );
		item.setMnemonic( 'H' );
		item.setEnabled( false );
//		GenericListener.connect( item, system, ActionListener.class, "actionPerformed", "showGameVersionInfo" );
		menu.add( item );

		item = new JMenuItem( (String)resources.getResource("peko.menu.help.version") );
		item.setMnemonic( 'A' );
		GenericListener.connect( item, system, ActionListener.class, "actionPerformed", "showGameVersionInfo" );
		menu.add( item );

		menu.addSeparator();

		item = new JMenuItem( (String)resources.getResource("peko.menu.help.about-pvns") );
		item.setMnemonic( 'P' );
		GenericListener.connect( item, system, ActionListener.class, "actionPerformed", "showSystemVersionInfo" );
		menu.add( item );


		JFrame	mainWindow = system.getMainWindow();
		mainWindow.setJMenuBar( menubar );
		mainWindow.pack();
		mainWindow.setResizable( false );
	}


//
//	MouseListener ̎
//
	public void mousePressed( MouseEvent ev )
	{
	}

	public void mouseReleased( MouseEvent ev )
	{
	}

	public void mouseEntered( MouseEvent ev )
	{
	}

	public void mouseExited( MouseEvent ev )
	{
	}

	public void mouseClicked( MouseEvent ev )
	{
		int	code = ev.getModifiers();
		if( isActive() && (code == MouseEvent.BUTTON1_MASK) )	{
			start();
		}
		else if( (_playMode == ActionControler.PM_SKIP) && (code == MouseEvent.BUTTON3_MASK) )	{
			setPlayModeToNormal();
			return;
		}
		else if( _hiddenText )	{
			CanvasManager	canvasManager = PekoSystem.getInstance().getCanvasManager();
			canvasManager.hideTextCanvas();
			setActive( true );
		}
	}


//
//	KeyListener ̎
//
	public void keyPressed( KeyEvent ev )
	{
		if( isActive() )	{
			int	code = ev.getKeyCode();
			if( _lastKeyCode == -1 )	{
				_lastKeyCode = code;
			}
			else if( _lastKeyCode != code )	{
				_lastKeyCode = -1;
			}
		}
	}

	public void keyReleased( KeyEvent ev )
	{
		int	code = ev.getKeyCode();
		if( code != _lastKeyCode )	{
			_lastKeyCode = -1;
			return;
		}

		if( _hiddenText )	{
			CanvasManager	canvasManager = PekoSystem.getInstance().getCanvasManager();
			canvasManager.showTextCanvas();
			_saveMenu.setEnabled( true );
			_loadMenu.setEnabled( true );
			_returnTileMenu.setEnabled( true );
			_hiddenText = false;
		}
		else if( isActive() && (code == KeyEvent.VK_ENTER) )	{
			start();
		}
		else if( (_playMode != ActionControler.PM_NORMAL) && (code == KeyEvent.VK_ESCAPE) )	{
			setPlayModeToNormal();
		}
		else if( !_hiddenText && (code == KeyEvent.VK_SPACE) )	{
			CanvasManager	canvasManager = PekoSystem.getInstance().getCanvasManager();
			_saveMenu.setEnabled( false );
			_loadMenu.setEnabled( false );
			_returnTileMenu.setEnabled( false );
			canvasManager.hideTextCanvas();
			_hiddenText = true;
		}
		_lastKeyCode = -1;
	}

	public void keyTyped( KeyEvent ev )
	{
	}
}




/**
 * eLXg̗uEWORg[łB
 */
class TextHistoryControler	extends JDialog	{

	/**
	 * ݂̃CfbNX
	 */
	private int	_index = 0;

	/**
	 * LoX}l[W
	 */
	private CanvasManager	_canvasManager = null;

	/**
	 * uOv{^
	 */
	private JButton	_previous = null;

	/**
	 * uv{^
	 */
	private JButton	_next = null;


	/**
	 * <code>TextHistoryControler</code> ̃CX^X쐬܂B
	 */
	public TextHistoryControler()
	{
		super( PekoSystem.getInstance().getMainWindow(), true );
		initialize();
	}


	/**
	 * s܂B
	 */
	private void initialize()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		_canvasManager = PekoSystem.getInstance().getCanvasManager();
		ClassLoader	cl = getClass().getClassLoader();

		getContentPane().setLayout( new java.awt.FlowLayout() );
		JButton	button = new JButton();
		button.setIcon( new ImageIcon(cl.getResource("left-arrow.png")) );
		getContentPane().add( button );
		GenericListener.connect( button, this, ActionListener.class, "actionPerformed", "previous" );
		_previous = button;
		button.setEnabled( (_canvasManager.getPageHistoryCount() >= 1) );

		button = new JButton();
		button.setIcon( new ImageIcon(cl.getResource("right-arrow.png")) );
		button.setEnabled( false );
		getContentPane().add( button );
		_next = button;
		GenericListener.connect( button, this, ActionListener.class, "actionPerformed", "next" );

		pack();
		setResizable( false );

		GenericListener.connect( this, this, WindowListener.class, "windowClosing", "hide" );
	}

	/**
	 * Õy[W\܂B
	 */
	private void previous()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		_index++;
		setTitle( ((MessageFormat)resources.getResource("peko.dialog.read-again.title-format")).format(new Object[]{String.valueOf(_index)}) );
		_next.setEnabled( (_index > 1 ) );
		if( _index == _canvasManager.getPageHistoryCount() )	{
			_previous.setEnabled( false );
		}
		_previous.setEnabled( _canvasManager.readAgain(_index) );
	}

	/**
	 * ̃y[W\܂B
	 */
	private void next()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		_index--;
		setTitle( ((MessageFormat)resources.getResource("peko.dialog.read-again.title-format")).format(new Object[]{String.valueOf(_index)}) );
		_previous.setEnabled( true );
		if( _index == 1 )	{
			_next.setEnabled( false );
		}
		_canvasManager.readAgain( _index );
	}


//
//	JDialog ̎
//
	public void show()
	{
		_index = 0;
		if( _canvasManager.getPageHistoryCount() > 0 )	{
			previous();
			super.show();
		}
	}

	public void hide()
	{
		_canvasManager.returnCurrent();
		super.hide();
	}
}