/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveDataInfo;
import tsukuba_bunko.peko.session.SaveDataInfoRenderer;

public class SaveDataDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public static final boolean FOR_SAVE = true;
    public static final boolean FOR_LOAD = false;
    protected int _selected = -1;
    protected SaveDataInfo[] _infoList = null;
    protected JList _list = null;
    protected JButton _ok = null;
    protected JButton _cancel = null;
    protected boolean _forSave = false;
    protected SaveDataInfoRenderer _renderer = null;

    public SaveDataDialog(boolean bl) {
        super((Frame)PekoSystem.getInstance().getMainWindow(), true);
        this._forSave = bl;
        ResourceManager resourceManager = ResourceManager.getInstance();
        Boolean bl2 = (Boolean)resourceManager.getResource("peko.savedata-chooser.dialog.decorated", true);
        if (bl2 != null) {
            this.setUndecorated(bl2 == false);
        }
        if (bl) {
            String string = (String)resourceManager.getResource("peko.savedata-chooser.dialog.title.save");
            if (string == null) {
                Logger.warn(MessageIDs.SAV0012W);
            } else {
                this.setTitle(string);
            }
        } else {
            String string = (String)resourceManager.getResource("peko.savedata-chooser.dialog.title.load");
            if (string == null) {
                Logger.warn(MessageIDs.SAV0012W);
            } else {
                this.setTitle(string);
            }
        }
        this._renderer = new SaveDataInfoRenderer();
    }

    protected void initialize(SaveDataInfo[] saveDataInfoArray, int n) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        JList<SaveDataInfo> jList = new JList<SaveDataInfo>(saveDataInfoArray);
        jList.setAutoscrolls(true);
        jList.setSelectionMode(0);
        jList.setCellRenderer(this._renderer);
        jList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setAutoscrolls(true);
        Integer n2 = (Integer)resourceManager.getResource("peko.savedata-chooser.items-at-once");
        if (n2 == null) {
            n2 = new Integer(5);
            Logger.warn(MessageIDs.SAV0013W, new Object[]{"5"});
        } else if (n2 <= 0) {
            n2 = new Integer(5);
            Logger.warn(MessageIDs.SAV0014W, new Object[]{"5"});
        }
        Dimension dimension = jScrollPane.getPreferredSize();
        Dimension dimension2 = this._renderer.getPreferredSize();
        dimension.height = dimension2.height * n2 + 5;
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setSize(dimension);
        Rectangle rectangle = new Rectangle(5, dimension2.height * (n - 1), dimension2.width, dimension2.height);
        jScrollPane.getViewport().scrollRectToVisible(rectangle);
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton();
        String string = (String)resourceManager.getResource("peko.savedata-chooser.button.ok");
        if (string == null) {
            string = "OK";
            Logger.warn(MessageIDs.SAV0019W, new Object[]{"OK", string});
        }
        jButton.setText(string);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton();
        string = (String)resourceManager.getResource("peko.savedata-chooser.button.cancel");
        if (string == null) {
            string = "CANCEL";
            Logger.warn(MessageIDs.SAV0019W, new Object[]{"Cancel", string});
        }
        jButton2.setText(string);
        jButton2.addActionListener(this);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jScrollPane);
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        this.setResizable(false);
        this._list = jList;
        this._ok = jButton;
        this._cancel = jButton2;
        this.getRootPane().setDefaultButton(this._ok);
        this._infoList = saveDataInfoArray;
        jList.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this._selected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._ok) {
            if (this._list.getSelectedValue() == null) {
                if (!this._forSave) return;
                this._selected = this._list.getSelectedIndex();
            } else if (this._forSave) {
                String string;
                ResourceManager resourceManager = ResourceManager.getInstance();
                String string2 = (String)resourceManager.getResource("peko.savedata-chooser.dialog.confirm.title");
                if (string2 == null) {
                    Logger.warn(MessageIDs.SAV0015W);
                }
                if ((string = (String)resourceManager.getResource("peko.savedata-chooser.dialog.confirm.message")) == null) {
                    string = "Do you overwrite save data ?";
                    Logger.warn(MessageIDs.SAV0016W, new Object[]{"\"" + string + "\""});
                }
                if (0 != JOptionPane.showConfirmDialog(this, string, string2, 0)) return;
                this._selected = this._list.getSelectedIndex();
            } else {
                this._selected = this._list.getSelectedIndex();
            }
        } else {
            this._selected = -1;
        }
        this.dispose();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._forSave) {
            return;
        }
        int n = this._list.getSelectedIndex();
        if (n != -1 && this._infoList[n] != null) {
            this._ok.setEnabled(true);
        } else {
            this._ok.setEnabled(false);
        }
    }

    public static int showDialog(SaveDataInfo[] saveDataInfoArray, int n, boolean bl) {
        SaveDataDialog saveDataDialog = new SaveDataDialog(bl);
        saveDataDialog.initialize(saveDataInfoArray, n);
        saveDataDialog.setLocationRelativeTo(saveDataDialog.getOwner());
        saveDataDialog.show();
        return saveDataDialog.getSelectedIndex();
    }
}

