/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import java.awt.Dimension;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.Coordinator;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.text.MessageIDs;
import tsukuba_bunko.peko.scenario.text.PageConfigurator;

public class TextCoordinator
extends Coordinator {
    protected boolean _pageConfigured = false;
    protected float _lineSpan = 0.0f;
    protected Line _lastLine = null;
    protected Dimension _sizeCache = new Dimension();

    public void prepare(SceneContext sceneContext, Thread thread) {
        super.prepare(sceneContext, thread);
        this._pageConfigured = false;
        this._lastLine = null;
    }

    public void begin() {
        if (this.isActiveThread()) {
            this._lastLine = null;
            this.getActionControler().setSaveEnabled(true);
        }
    }

    public void commit() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(false);
            this.getCurrentPage().commit();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushText(String string) {
        int n;
        if (!this.isActiveThread()) {
            return;
        }
        Page page = this.getCurrentPage();
        if (!this._pageConfigured) {
            PageConfigurator.configure(page, this.getSceneContext());
            this._pageConfigured = true;
            this._lineSpan = this.getLineSpan();
        }
        if ((n = string.length()) == 0) {
            Logger.debug("[scnario.text] empty string is pecified.");
            return;
        }
        if (this._lastLine != null) {
            string = this._lastLine.getText() + string;
            n = string.length();
        }
        Logger.debug(string);
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, page.getDefaultFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, page.getForeground());
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), page.getFontRenderContext());
        float f = page.getMaxLineWidth();
        float f2 = this._lineSpan;
        boolean bl = false;
        TextLayout textLayout = null;
        Line line = null;
        textLayout = lineBreakMeasurer.nextLayout(f);
        line = new Line();
        line.setTextLayout(textLayout);
        line.setText(string.substring(0, lineBreakMeasurer.getPosition()));
        line.setForeground(page.getForeground());
        line.setShadowColor(page.getShadow());
        if (this._lastLine == null) {
            if (!this.isActiveThread()) return;
            line.setLineSpan(f2);
            if (!page.isAdaptive(line)) {
                page = this.advancesNewPage();
            }
            page.addLine(line);
        } else {
            line.setLineSpan(f2);
            if (!this.isActiveThread()) return;
            page.setLine(page.getLineCount() - 1, line);
            if (this._lastLine.getText().equals(line.getText())) {
                bl = true;
            }
        }
        this._lastLine = line;
        int n2 = 0;
        while ((n2 = lineBreakMeasurer.getPosition()) < n) {
            line = new Line();
            line.setTextLayout(lineBreakMeasurer.nextLayout(f));
            line.setLineSpan(f2);
            line.setText(string.substring(n2, lineBreakMeasurer.getPosition()));
            line.setForeground(page.getForeground());
            line.setShadowColor(page.getShadow());
            if (!this.isActiveThread()) return;
            if (!page.isAdaptive(line)) {
                if (bl) {
                    bl = false;
                } else {
                    page.updateContents();
                    this.stop();
                }
                page = this.advancesNewPage();
            }
            if (page == null) {
                return;
            }
            page.addLine(line);
            bl = false;
            this._lastLine = line;
        }
        if (!this.isActiveThread()) return;
        page.updateContents();
    }

    public Page getCurrentPage() {
        return this.getCanvasManager().getCurrentPage();
    }

    public Page advancesNewPage() {
        if (this.isActiveThread()) {
            return this.getCanvasManager().advancesNewPage();
        }
        return null;
    }

    protected void stop() {
        if (this.isActiveThread()) {
            this.getActionControler().stop();
        }
    }

    protected float getLineSpan() {
        ResourceManager resourceManager;
        Float f;
        SceneContext sceneContext = this.getSceneContext();
        String string = sceneContext.getProperty("canvas.text.line-span");
        if (string != null) {
            try {
                return Float.parseFloat(string);
            }
            catch (Exception exception) {
                Logger.warn(MessageIDs.SCN2002W, (Throwable)exception);
            }
        }
        if ((f = (Float)(resourceManager = ResourceManager.getInstance()).getResource("peko.canvas.text.line-span")) != null) {
            return f.floatValue();
        }
        Logger.warn(MessageIDs.SCN2001W, new Object[]{"20.0"});
        return 20.0f;
    }
}

