/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.select;

import java.util.ArrayList;
import java.util.List;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.scenario.Coordinator;

public class SelectCoordinator
extends Coordinator {
    protected List _selectItems = null;
    protected Thread _activeThread = null;

    public void begin() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(true);
            this._selectItems = new ArrayList(4);
        }
    }

    public void commit() {
        if (this.isActiveThread()) {
            this.getActionControler().setSaveEnabled(false);
        }
    }

    public void addSelectItem(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("id is not specified.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("text is not specified.");
        }
        if (this.isActiveThread()) {
            SelectItem selectItem = new SelectItem();
            selectItem.setID(string);
            selectItem.setText(string2);
            this._selectItems.add(selectItem);
        }
    }

    public String select() {
        if (this.isActiveThread()) {
            if (this._selectItems == null || this._selectItems.isEmpty()) {
                Logger.debug("[scenario.select] no select items!");
                return null;
            }
            CanvasManager canvasManager = this.getCanvasManager();
            String string = canvasManager.showSelect(this._selectItems);
            if (string == null) {
                Logger.debug("[scenario.select] canceled.");
            }
            canvasManager.advancesNewPage();
            return string;
        }
        return null;
    }

    public void end() {
        if (this.isActiveThread()) {
            this._activeThread = null;
            if (this._selectItems != null) {
                this._selectItems.clear();
                this._selectItems = null;
            }
        }
    }
}

