/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.HandlerRegistry;
import tsukuba_bunko.peko.scenario.MessageIDs;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.ScenarioProcessor;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.select.SelectCoordinator;
import tsukuba_bunko.peko.scenario.stage.StageCoordinator;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.session.Session;

public class SceneProcessor
extends DefaultHandler
implements Runnable {
    public static final String PSML_PUBLICID = "-//Tsukuba Bunko//DTD PSML Scene 1.0//EN";
    public static final String PSML_SYSTEMID = "http://softlab.tsukuba-bunko.org/dtd/psml10-scene.dtd";
    protected SAXParser _parser = null;
    protected boolean _running = false;
    protected boolean _aborted = false;
    protected URL _sceneURL = null;
    protected SceneContext _sceneContext = null;
    protected ScenarioProcessor _owner = null;
    protected int _level = -1;
    protected int _processStartedLevel = -1;
    protected int _ignoreStartedLevel = -1;
    protected HandlerRegistry _registry = null;
    protected ElementHandler _handler = null;
    protected SceneContext.Node _startNode = null;
    protected TextCoordinator _textCoordinator = null;
    protected StageCoordinator _stageCoordinator = null;
    protected SelectCoordinator _selectCoordinator = null;

    public SceneProcessor(ScenarioProcessor scenarioProcessor) {
        this._owner = scenarioProcessor;
        this._registry = HandlerRegistry.newInstance();
        this.getSAXParser();
        Logger.debug("[scenario] create SceneProcessor.");
    }

    public SceneContext getSceneContext() {
        return this._sceneContext;
    }

    public HandlerRegistry getHandlerRegistry() {
        return this._registry;
    }

    public void setTextCoordinator(TextCoordinator textCoordinator) {
        this._textCoordinator = textCoordinator;
    }

    public TextCoordinator getTextCoordinator() {
        return this._textCoordinator;
    }

    public void setStageCoordinator(StageCoordinator stageCoordinator) {
        this._stageCoordinator = stageCoordinator;
    }

    public StageCoordinator getStageCoordinator() {
        return this._stageCoordinator;
    }

    public void setSelectCoordinator(SelectCoordinator selectCoordinator) {
        this._selectCoordinator = selectCoordinator;
    }

    public SelectCoordinator getSelectCoordinator() {
        return this._selectCoordinator;
    }

    public void process(String string, Session session) {
        Object object;
        if (this._running) {
            object = new IllegalStateException("scene processor is still running.");
            Logger.fatal(MessageIDs.SCN0007F);
            PekoSystem.showErrorDialog(MessageIDs.SCN0007F.getMessage(), ((Throwable)object).fillInStackTrace(), true);
        }
        this._sceneURL = this.getSceneURL(string);
        this._sceneContext = new SceneContext(string, session, this);
        this._startNode = this._sceneContext.getLastCommittedNode();
        if (this._startNode != null) {
            Logger.debug("[scenario.scene] start from: " + this._startNode.getPath());
        }
        object = new Thread(this);
        session.setSceneContext(this._sceneContext, (Thread)object);
        this._textCoordinator.prepare(this._sceneContext, (Thread)object);
        this._stageCoordinator.prepare(this._sceneContext, (Thread)object);
        this._selectCoordinator.prepare(this._sceneContext, (Thread)object);
        this._aborted = false;
        ((Thread)object).start();
    }

    public void abort() {
        this._aborted = true;
        this._textCoordinator.dormantize();
        this._stageCoordinator.dormantize();
        this._selectCoordinator.dormantize();
        Logger.debug("[scenario] release stopped thread.");
        ActionControler actionControler = PekoSystem.getInstance().getActionControler();
        actionControler.start();
    }

    public boolean isAborted() {
        return this._aborted;
    }

    protected SAXParser getSAXParser() {
        if (this._parser == null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                if ("on".equals(System.getProperty("debug", "off"))) {
                    Logger.debug("[scenario.scene] set PSML validating on.");
                    sAXParserFactory.setValidating(true);
                } else {
                    Logger.debug("[scenario.scene] set PSML validating off.");
                    sAXParserFactory.setValidating(false);
                }
                this._parser = sAXParserFactory.newSAXParser();
            }
            catch (SAXException sAXException) {
                Logger.fatal(MessageIDs.SCN0000F);
                PekoSystem.showErrorDialog(MessageIDs.SCN0000F.getMessage(), sAXException, true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Logger.fatal(MessageIDs.SCN0000F);
                PekoSystem.showErrorDialog(MessageIDs.SCN0000F.getMessage(), parserConfigurationException, true);
            }
        }
        return this._parser;
    }

    protected URL getSceneURL(String string) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        URL uRL = resourceManager.getLocationResources().getScenesDirecotryURL();
        try {
            return new URL(uRL, string);
        }
        catch (Exception exception) {
            Logger.fatal(MessageIDs.SCN0006F, (Throwable)exception);
            PekoSystem.showErrorDialog(MessageIDs.SCN0006F.getMessage(), exception, true);
            return null;
        }
    }

    public void run() {
        this._running = true;
        try {
            Logger.debug(this._sceneURL.toString());
            SAXParser sAXParser = this.getSAXParser();
            sAXParser.parse(this._sceneURL.toString(), (DefaultHandler)this);
        }
        catch (Exception exception) {
            Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, exception);
            PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), exception, true);
        }
        this._running = false;
        this._owner.pushSceneProcessor(this);
    }

    public void startDocument() throws SAXException {
        if (this._aborted) {
            return;
        }
        this._level = 0;
        this._processStartedLevel = -1;
        this._ignoreStartedLevel = -1;
        this._handler = null;
    }

    public void endDocument() throws SAXException {
        if (this._aborted) {
            return;
        }
        this._owner.sceneEnded(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this._aborted) {
            return;
        }
        ++this._level;
        this._sceneContext.pushNode(string3);
        if (this._startNode != null) {
            if (!this._sceneContext.isCurrentNode(this._startNode)) return;
            this._startNode = null;
        } else {
            if (this._ignoreStartedLevel != -1) {
                return;
            }
            if (!PSMLUtil.isEvaluatable(attributes, this._sceneContext)) {
                this._ignoreStartedLevel = this._level;
                return;
            }
        }
        if (this._handler == null) {
            this._handler = this._registry.getElementHandler(string, string2);
            if (this._handler == null) {
                return;
            }
            this._sceneContext.saveCurrentNode();
            this._handler.setSceneContext(this._sceneContext);
            this._processStartedLevel = this._level;
            this._handler.startDocument();
        }
        try {
            this._handler.startElement(string, string2, string3, attributes);
            return;
        }
        catch (Exception exception) {
            Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, exception);
            PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), exception, true);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._aborted) {
            return;
        }
        if (this._startNode == null) {
            if (this._level == this._ignoreStartedLevel) {
                this._ignoreStartedLevel = -1;
            } else if (this._ignoreStartedLevel == -1 && this._handler != null) {
                try {
                    this._handler.endElement(string, string2, string3);
                    if (this._level == this._processStartedLevel) {
                        this._handler.endDocument();
                        if (this._handler.isEndOfScene()) {
                            this._owner.sceneEnded(this);
                            this._aborted = true;
                        }
                        this._handler = null;
                        this._processStartedLevel = -1;
                    }
                }
                catch (Exception exception) {
                    Logger.fatal(MessageIDs.SCN0005F, new Object[]{this._sceneContext.getCurrentPath()}, exception);
                    PekoSystem.showErrorDialog(MessageIDs.SCN0005F.getMessage(new Object[]{this._sceneContext.getCurrentPath()}), exception, true);
                }
            }
        }
        --this._level;
        this._sceneContext.popNode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._aborted) {
            return;
        }
        if (this._ignoreStartedLevel != -1 || this._handler == null) {
            return;
        }
        if (this._handler != null) {
            this._handler.characters(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) {
    }

    public void warning(SAXParseException sAXParseException) {
        Logger.warn(MessageIDs.SCN0002W, new Object[]{sAXParseException.getMessage()}, sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        Logger.error(MessageIDs.SCN0003E, new Object[]{sAXParseException.getMessage()}, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        Logger.fatal(MessageIDs.SCN0004F, new Object[]{sAXParseException.getMessage()}, sAXParseException);
        PekoSystem.showErrorDialog("fail to parsing scene data.", sAXParseException, true);
    }

    public InputSource resolveEntity(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            if (PSML_PUBLICID.equals(string)) {
                bl = true;
            }
        } else if (string2 != null && PSML_SYSTEMID.equals(string2)) {
            bl = true;
        }
        if (bl) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("psml10-scene.dtd");
            }
            catch (Exception exception) {
                Logger.warn(MessageIDs.SCN0001W, (Throwable)exception);
                return null;
            }
            if (inputStream != null) {
                return new InputSource(inputStream);
            }
            Logger.warn(MessageIDs.SCN0001W);
            return null;
        }
        return null;
    }
}

