/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.NextSceneMapping;
import tsukuba_bunko.peko.scenario.SceneProcessor;
import tsukuba_bunko.peko.session.Session;

public class SceneContext
implements Serializable {
    protected String _sceneName = null;
    protected String _sceneTitle = null;
    protected Map _properties = null;
    protected NextSceneMapping _nextSceneMapping = null;
    protected transient Node _current = null;
    protected Node _lastCommittedNode = null;
    protected Set _sceneScopeFlags = null;
    protected transient Session _session = null;
    protected transient SceneProcessor _processor = null;

    public SceneContext(String string, Session session, SceneProcessor sceneProcessor) {
        this._sceneName = string;
        this._session = session;
        this._processor = sceneProcessor;
        SceneContext sceneContext = session.getSceneContext();
        if (sceneContext != null) {
            this._lastCommittedNode = sceneContext.getLastCommittedNode();
            this._properties = sceneContext._properties;
            this._nextSceneMapping = sceneContext.getNextSceneMapping();
            this._sceneScopeFlags = sceneContext._sceneScopeFlags;
        } else {
            this._nextSceneMapping = new NextSceneMapping();
            this._sceneScopeFlags = new HashSet();
        }
    }

    public String getSceneName() {
        return this._sceneName;
    }

    public void setSceneTitle(String string) {
        this._sceneTitle = string;
    }

    public String getSceneTitle() {
        return this._sceneTitle;
    }

    public Session getSession() {
        return this._session;
    }

    public SceneProcessor getSceneProcessor() {
        return this._processor;
    }

    public void setProperty(String string, String string2) {
        if (this._properties == null) {
            this._properties = new HashMap(17);
        }
        this._properties.put(string, string2);
    }

    public String getProperty(String string) {
        if (this._properties == null) {
            return null;
        }
        return (String)this._properties.get(string);
    }

    public void setNextSceneMapping(NextSceneMapping nextSceneMapping) {
        this._nextSceneMapping = nextSceneMapping;
    }

    public NextSceneMapping getNextSceneMapping() {
        return this._nextSceneMapping;
    }

    public String getNextSceneName() {
        return this._nextSceneMapping.getNextScene(this);
    }

    public void pushNode(String string) {
        if (this._current == null) {
            this._current = new Node(null, string.intern(), 1);
        } else {
            int n = this._current.countSibling(string) + 1;
            Node node = new Node(this._current, string.intern(), n);
            this._current.addChildNode(node);
            this._current = node;
        }
    }

    public void popNode() {
        if (this._current == null) {
            Logger.error("[scenario] BUG! invalid state of SceneLog.");
        } else {
            this._current.removeChildren();
            this._current = this._current.getParentNode();
        }
    }

    public void saveCurrentNode() {
        this._lastCommittedNode = this._current;
    }

    public Node getLastCommittedNode() {
        return this._lastCommittedNode;
    }

    public boolean isCurrentNode(Node node) {
        if (node == this._current) {
            return true;
        }
        if (this._current != null) {
            return this._current.equals(node);
        }
        return false;
    }

    public Node getCurrentNode() {
        Node node;
        Node node2 = this._current;
        if (node2 == null) {
            return null;
        }
        Node node3 = node = new Node(null, node2._nodeName, node2._position);
        while ((node2 = node2.getParentNode()) != null) {
            node3._parent = new Node(null, node2.getNodeName(), node2.getPosition());
            node3 = node3.getParentNode();
        }
        return node;
    }

    public String getCurrentPath() {
        if (this._current != null) {
            return this._current.getPath();
        }
        return "/";
    }

    public void declareFlag(String string, FlagScope flagScope) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (flagScope == FlagScope.SCENE) {
            this._sceneScopeFlags.add(string);
        } else if (flagScope == FlagScope.SESSION) {
            this._session.declareSessionFlag(string);
        } else if (flagScope == FlagScope.SYSTEM) {
            this._session.declareSystemFlag(string);
        }
    }

    public void undeclareFlag(String string, FlagScope flagScope) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (flagScope == FlagScope.SCENE) {
            this._sceneScopeFlags.remove(string);
        } else if (flagScope == FlagScope.SESSION) {
            this._session.undeclareSessionFlag(string);
        } else if (flagScope == FlagScope.SYSTEM) {
            this._session.undeclareSystemFlag(string);
        }
    }

    public boolean isDeclaredFlag(String string) {
        if (this._sceneScopeFlags.contains(string)) {
            return true;
        }
        if (this._session.isDeclaredSessionFlag(string)) {
            return true;
        }
        return this._session.isDeclaredSystemFlag(string);
    }

    public boolean isDeclaredFlag(String string, FlagScope flagScope) {
        if (flagScope == FlagScope.SCENE) {
            return this._sceneScopeFlags.contains(string);
        }
        if (flagScope == FlagScope.SESSION) {
            return this._session.isDeclaredSessionFlag(string);
        }
        if (flagScope == FlagScope.SYSTEM) {
            return this._session.isDeclaredSystemFlag(string);
        }
        return false;
    }

    public static class Node
    implements Serializable {
        protected Node _parent = null;
        protected String _nodeName = null;
        protected int _position = 0;
        protected List _children = null;

        public Node(Node node, String string, int n) {
            this._parent = node;
            this._nodeName = string.intern();
            this._position = n;
        }

        public Node getParentNode() {
            return this._parent;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public int getPosition() {
            return this._position;
        }

        public void addChildNode(Node node) {
            if (this._children == null) {
                this._children = new ArrayList();
            }
            this._children.add(node);
        }

        public int countSibling(String string) {
            if (this._children == null) {
                return 0;
            }
            String string2 = string.intern();
            List list = this._children;
            int n = list.size();
            Node node = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                node = (Node)list.get(i);
                if (node._nodeName != string2) continue;
                ++n2;
            }
            return n2;
        }

        public void removeChildren() {
            if (this._children != null) {
                List list = this._children;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    ((Node)list.get(i)).removeChildren();
                }
                list.clear();
                this._children = null;
            }
        }

        public String getPath() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Node node = this; node != null; node = node.getParentNode()) {
                stringBuffer.insert(0, node);
            }
            return new String(stringBuffer);
        }

        public boolean equals(Object object) {
            if (object instanceof Node) {
                Node node = (Node)object;
                Node node2 = this;
                while (node2 != null && node != null) {
                    if (!node2._nodeName.equals(node._nodeName) || node2._position != node._position) {
                        return false;
                    }
                    node2 = node2._parent;
                    node = node._parent;
                }
                return node2 == null && node == null;
            }
            return false;
        }

        public String toString() {
            return "/" + this._nodeName + "[" + this._position + "]";
        }
    }
}

