/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.net.URL;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.IconDeserializer;
import tsukuba_bunko.peko.resource.LocationConfigurator;
import tsukuba_bunko.peko.resource.LocationResources;
import tsukuba_bunko.peko.resource.MessageIDs;
import tsukuba_bunko.peko.resource.PekoResourceLoader;
import tsukuba_bunko.resource.DeserializerMapping;
import tsukuba_bunko.resource.Resources;

public class ResourceManager {
    protected static final String RES_MESSAGE = "messages.xml";
    protected static final String RES_SYSTEM = "system.xml";
    protected static final String RES_MENU = "menu.xml";
    protected static final String RES_DIALOG = "dialog.xml";
    protected static final String RES_CANVAS = "canvas.xml";
    protected static final String RES_GAME = "game-info.xml";
    protected static final String RES_TITLE = "title.xml";
    private static ResourceManager _instance = null;
    private PekoResourceLoader _loader = null;
    private Resources _resources = null;
    private LocationResources _locationResources = null;
    static /* synthetic */ Class class$tsukuba_bunko$peko$resource$ResourceManager;

    protected ResourceManager() {
    }

    public boolean exists(String string) {
        return this._resources.getResource(string) != null;
    }

    public Object getResource(String string) {
        return this.getResource(string, false);
    }

    public Object getResource(String string, boolean bl) {
        Object object = this._resources.getResource(string);
        if (!bl && object == null) {
            Logger.warn(MessageIDs.RES0001W.getMessage(new Object[]{string}));
        }
        return object;
    }

    public LocationResources getLocationResources() {
        return this._locationResources;
    }

    private PekoResourceLoader getResourceLoader() {
        try {
            if (this._loader == null) {
                this._loader = new PekoResourceLoader();
            }
            return this._loader;
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to create instance of PekoResourceLoader", exception);
            Logger.fatal(MessageIDs.RES0014F, (Throwable)exception);
            throw initializationError;
        }
    }

    private void loadLogMessages() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_MESSAGE);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of log messgages.");
                Logger.fatal("[RES9998F] missing resource file of log messgages.", (Throwable)initializationError);
                throw initializationError;
            }
            Logger.debug("loading log messages from " + uRL.toString());
            this._resources = Resources.newInstance(uRL);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of log messages.", exception);
            Logger.fatal("[RES9999F] fail to load resources of log messages.", (Throwable)initializationError);
            throw initializationError;
        }
    }

    private void loadSystemConfigurationResources() {
        Object object;
        try {
            object = this.getClass().getClassLoader().getResource(RES_SYSTEM);
            if (object == null) {
                InitializationError initializationError = new InitializationError("missing resource file of PVNS resource.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_SYSTEM}, initializationError);
                throw initializationError;
            }
            Logger.debug("loadingresources of system configuration from " + ((URL)object).toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            pekoResourceLoader.loadResource((URL)object, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of system configuration", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_SYSTEM}, initializationError);
            throw initializationError;
        }
        object = new LocationConfigurator();
        this._locationResources = ((LocationConfigurator)object).configure(this._resources);
    }

    private void loadMenuResources() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_MENU);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of menu items.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_MENU}, initializationError);
                throw initializationError;
            }
            Logger.debug("loading resources of menu items from " + uRL.toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            pekoResourceLoader.loadResource(uRL, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of menu item configuration", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_SYSTEM}, initializationError);
            throw initializationError;
        }
    }

    private void loadDialogConfigurationResources() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_DIALOG);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of dialog configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_DIALOG}, initializationError);
                throw initializationError;
            }
            Logger.debug("loading resources of dialog configuration from " + uRL.toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            pekoResourceLoader.loadResource(uRL, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of dialog configuration", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_DIALOG}, initializationError);
            throw initializationError;
        }
    }

    private void loadCanvasConfigurationResources() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_CANVAS);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of canvas configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_CANVAS}, initializationError);
                throw initializationError;
            }
            Logger.debug("loading resources of canvas configuration from " + uRL.toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            pekoResourceLoader.loadResource(uRL, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of canvas configuration", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_CANVAS}, initializationError);
            throw initializationError;
        }
    }

    private void loadTitleConfigurationResources() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_TITLE);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of title configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_TITLE}, initializationError);
                throw initializationError;
            }
            Logger.debug("loading resources of title configuration from " + uRL.toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            pekoResourceLoader.loadResource(uRL, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of title configuration", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_TITLE}, initializationError);
            throw initializationError;
        }
    }

    private void loadGameInfoResources() {
        try {
            URL uRL = this.getClass().getClassLoader().getResource(RES_GAME);
            if (uRL == null) {
                InitializationError initializationError = new InitializationError("missing resource file of game information resource.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_GAME}, initializationError);
                throw initializationError;
            }
            Logger.debug("loading game information resources from " + uRL.toString());
            PekoResourceLoader pekoResourceLoader = this.getResourceLoader();
            DeserializerMapping deserializerMapping = pekoResourceLoader.getDeserializerMapping();
            IconDeserializer iconDeserializer = (IconDeserializer)deserializerMapping.getResourceDeserializer("peko:icon");
            iconDeserializer.setBaseURL(this._locationResources.getMiscDirecotryURL());
            pekoResourceLoader.loadResource(uRL, this._resources);
        }
        catch (Exception exception) {
            InitializationError initializationError = new InitializationError("fail to load resources of game information resource", exception);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_GAME}, initializationError);
            throw initializationError;
        }
    }

    private void initialize() {
        Logger.debug("[resource] start initializing ResourceManager.");
        this.loadLogMessages();
        this.loadSystemConfigurationResources();
        this.loadMenuResources();
        this.loadDialogConfigurationResources();
        this.loadCanvasConfigurationResources();
        this.loadTitleConfigurationResources();
        this.loadGameInfoResources();
        Logger.debug("[resource] finish initializing ResourceManager.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceManager getInstance() {
        if (_instance == null) {
            Class clazz = class$tsukuba_bunko$peko$resource$ResourceManager == null ? (class$tsukuba_bunko$peko$resource$ResourceManager = ResourceManager.class$("tsukuba_bunko.peko.resource.ResourceManager")) : class$tsukuba_bunko$peko$resource$ResourceManager;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new ResourceManager();
                    _instance.initialize();
                }
            }
        }
        return _instance;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

