/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.LocationResources;
import tsukuba_bunko.peko.resource.MessageIDs;
import tsukuba_bunko.resource.Resources;
import tsukuba_bunko.util.ResourceLocator;

public class LocationConfigurator {
    protected File detectInstallDirectory() {
        File file = null;
        try {
            ResourceLocator resourceLocator = ResourceLocator.newInstance();
            file = resourceLocator.findLocation("tsukuba_bunko/peko/PekoSystem.class");
            file = file.isFile() ? file.getParentFile().getParentFile() : file.getParentFile();
        }
        catch (Exception exception) {
            Logger.fatal(MessageIDs.RES0006F, (Throwable)exception);
            throw new InitializationError("fail to detect install directory.", exception);
        }
        Logger.debug("install dir: " + file.getAbsolutePath());
        return file;
    }

    protected URL configureDirectoryURL(String string, File file) {
        File file2 = new File(file, string);
        Logger.debug("dir: " + file2);
        if (file2.isDirectory()) {
            try {
                return file2.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                InitializationError initializationError = new InitializationError("invalid data directory.", malformedURLException);
                Logger.fatal(MessageIDs.RES0008F, new Object[]{string}, initializationError);
                throw initializationError;
            }
        }
        if (file2.isFile()) {
            try {
                return new URL("jar:" + file2.toURL().toString() + "!/");
            }
            catch (MalformedURLException malformedURLException) {
                InitializationError initializationError = new InitializationError("invalid data directory.", malformedURLException);
                Logger.fatal(MessageIDs.RES0008F, new Object[]{string}, initializationError);
                throw initializationError;
            }
        }
        InitializationError initializationError = new InitializationError("invalid data directory.");
        Logger.fatal(MessageIDs.RES0008F, new Object[]{string}, initializationError);
        throw initializationError;
    }

    protected File ensureSaveDirectory(String string, File file) {
        File file2 = new File(file, string);
        if (file2.exists()) {
            if (file2.isDirectory()) {
                return file2;
            }
            InitializationError initializationError = new InitializationError("already exist file.");
            Logger.fatal(MessageIDs.RES0012F, (Throwable)initializationError);
            throw initializationError;
        }
        if (!file2.mkdir()) {
            InitializationError initializationError = new InitializationError("fail to create dir.");
            Logger.fatal(MessageIDs.RES0013F, (Throwable)initializationError);
            throw initializationError;
        }
        return file2;
    }

    public LocationResources configure(Resources resources) {
        LocationResources locationResources = new LocationResources();
        File file = this.detectInstallDirectory();
        String[] stringArray = new String[]{"scenes", "images", "sounds", "misc"};
        URL uRL = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = (String)resources.getResource("peko.system.location." + stringArray[i]);
            if (string == null) {
                InitializationError initializationError = new InitializationError("directory is not specified.");
                Logger.fatal(MessageIDs.RES0011F, new Object[]{stringArray[i]}, initializationError);
                throw initializationError;
            }
            uRL = this.configureDirectoryURL(string, file);
            Logger.debug(uRL.toString());
            locationResources.setResource("peko.system.location." + stringArray[i], uRL);
        }
        String string2 = (String)resources.getResource("peko.system.location.save");
        if (string2 == null) {
            string2 = "save";
        }
        locationResources.setResource("peko.system.location.save", this.ensureSaveDirectory(string2, file));
        locationResources.setResource("peko.system.location.install", file);
        return locationResources;
    }
}

