/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.resource.BasicDeserializer;

public class FontDeserializer
extends BasicDeserializer {
    protected Map _fontAttributes = null;
    protected StringBuffer _text = null;

    public void startDocument() {
        this._fontAttributes = new HashMap();
        this._fontAttributes.put(TextAttribute.FAMILY, "Serif");
        this._fontAttributes.put(TextAttribute.SIZE, new Float(20.0f));
        this._fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        this._fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
    }

    public void endDocument() {
        FontManager fontManager = FontManager.getInstance();
        this.setValue(fontManager.getFont(this._fontAttributes));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this._text = new StringBuffer();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        if (string3.equals("family")) {
            this._fontAttributes.put(TextAttribute.FAMILY, new String(this._text));
        } else if (string3.equals("size")) {
            try {
                this._fontAttributes.put(TextAttribute.SIZE, Float.valueOf(new String(this._text)));
            }
            catch (Exception exception) {
                Logger.warn("[resource.font] invalid font size is specified :" + this._text, (Throwable)exception);
            }
        } else if (string3.equals("style")) {
            String string5 = new String(this._text);
            if ("italic".equals(string5)) {
                this._fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
        } else if (string3.equals("weight") && "bold".equals(string4 = new String(this._text))) {
            this._fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        this._text = null;
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this._text != null) {
            this._text.append(cArray, n, n2);
        }
    }
}

