/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import javax.swing.JComponent;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.text.Line;
import tsukuba_bunko.peko.canvas.text.Page;

public class Marker
extends JComponent
implements Runnable {
    private Line _text = null;
    private boolean _light = false;
    private Thread _blinker = null;
    private boolean _blinking = false;

    public void setText(Line line) {
        this._text = line;
        int n = (int)(line.getAscent() + line.getDescent());
        int n2 = (int)line.getTextLayout().getAdvance();
        Dimension dimension = new Dimension(n2, n);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public void setText(String string, Page page) {
        this.setForeground(page.getForeground());
        TextLayout textLayout = new TextLayout(string, page.getDefaultFont(), page.getFontRenderContext());
        Line line = new Line();
        line.setLineSpan(0.0f);
        line.setTextLayout(textLayout);
        line.setForeground(page.getForeground());
        line.setShadowColor(page.getShadow());
        this.setText(line);
    }

    public Line getText() {
        return this._text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this._blinker == null) {
            Marker marker = this;
            synchronized (marker) {
                if (this._blinker == null) {
                    this._blinker = new Thread(this);
                    this._blinking = true;
                    this._blinker.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Marker marker = this;
        synchronized (marker) {
            this._blinking = false;
            this.notify();
        }
    }

    public void setPosition(int n, int n2) {
        if (this._text != null) {
            this.setLocation(n, n2 - (int)(this._text.getAscent() + this._text.getDescent()));
        } else {
            this.setLocation(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.debug("[canvas.text] blinking start.");
        while (this._blinking) {
            Marker marker = this;
            synchronized (marker) {
                try {
                    this.wait(520L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean bl = this._light = !this._light;
            if (!this.isVisible()) continue;
            this.repaint();
        }
        Logger.debug("[canvas.text] blinking stop.");
    }

    protected void paintComponent(Graphics graphics) {
        if (!this._light || this._text == null || !this.isVisible()) {
            return;
        }
        this._text.draw((Graphics2D)graphics, 0.0f, this._text.getAscent());
    }
}

