/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.AudioClip;
import tsukuba_bunko.peko.canvas.stage.audio.MP3AudioClip;
import tsukuba_bunko.peko.canvas.stage.audio.SampledAudioClip;
import tsukuba_bunko.peko.resource.ResourceManager;

public class AudioPlayer
implements Serializable {
    private transient Map _clips = new HashMap(17);
    private Map _bgmRegistry = new HashMap(17);
    private Map _seRegistry = new HashMap(17);

    public void playBGM(String string, String string2, boolean bl) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        try {
            if (this._clips.containsKey(string)) {
                Logger.error("[canvas.stage] specified bgm clip id was already used. :" + string);
                return;
            }
            this._bgmRegistry.put(string, new Object[]{string2, bl ? Boolean.TRUE : Boolean.FALSE});
            URL uRL = new URL(resourceManager.getLocationResources().getSoundsDirecotryURL(), string2);
            this.playClip(string, uRL, bl);
        }
        catch (Exception exception) {
            Logger.error("[canvas.stage] fail to play bgm :" + string2, (Throwable)exception);
        }
    }

    public void playSE(String string, String string2, boolean bl) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        try {
            if (this._clips.containsKey(string)) {
                Logger.error("[canvas.stage] specified se clip id was already used. :" + string);
                return;
            }
            this._seRegistry.put(string, new Object[]{string2, bl ? Boolean.TRUE : Boolean.FALSE});
            URL uRL = new URL(resourceManager.getLocationResources().getSoundsDirecotryURL(), string2);
            this.playClip(string, uRL, bl);
        }
        catch (Exception exception) {
            Logger.error("[canvas.stage] fail to play bgm :" + string2, (Throwable)exception);
        }
    }

    protected void playClip(String string, URL uRL, boolean bl) {
        try {
            AudioClip audioClip = this.getAudioClip(string, uRL);
            if (audioClip != null) {
                this.register(audioClip);
                audioClip.play(bl);
            }
        }
        catch (Exception exception) {
            Logger.error("[canvas.stage] fail to play clip. :" + uRL, (Throwable)exception);
        }
    }

    protected void register(AudioClip audioClip) {
        audioClip.setAudioPlayer(this);
        this._clips.put(audioClip.getID(), audioClip);
        Logger.debug("[canvas.stage] registered clip :" + audioClip.getID());
    }

    protected void unregister(AudioClip audioClip) {
        this._clips.remove(audioClip.getID());
        this._bgmRegistry.remove(audioClip.getID());
        this._seRegistry.remove(audioClip.getID());
        Logger.debug("[canvas.stage] unregistered clip :" + audioClip.getID());
    }

    public void stop(String string) {
        AudioClip audioClip = (AudioClip)this._clips.get(string);
        if (audioClip != null) {
            audioClip.stop();
        }
    }

    public void stopAll() {
        AudioClip[] audioClipArray = this._clips.values().toArray(new AudioClip[this._clips.size()]);
        for (int i = 0; i < audioClipArray.length; ++i) {
            audioClipArray[i].stop();
        }
    }

    protected AudioClip getAudioClip(String string, URL uRL) {
        String string2 = uRL.getFile().toLowerCase();
        if (string2.endsWith(".mid") || string2.equals(".smf")) {
            Logger.error("[canvas.stage] unsupported format :" + uRL);
            return null;
        }
        if (string2.endsWith("mp3")) {
            return new MP3AudioClip(string, uRL);
        }
        if (string2.endsWith(".wav") || string2.endsWith(".au")) {
            return new SampledAudioClip(string, uRL);
        }
        Logger.error("[canvas.stage] unsupported format :" + uRL);
        return null;
    }

    public void prepare() {
        int n;
        if (this._clips == null) {
            Logger.debug("[cavnas.stage] initialize clips.");
            this._clips = new HashMap(17);
        }
        String[] stringArray = null;
        Object[] objectArray = null;
        Map map = this._bgmRegistry;
        if (map.size() > 0) {
            stringArray = map.keySet().toArray(new String[map.size()]);
            for (n = 0; n < stringArray.length; ++n) {
                objectArray = (Object[])map.get(stringArray[n]);
                this.playBGM(stringArray[n], (String)objectArray[0], (Boolean)objectArray[1]);
            }
        }
        if ((map = this._seRegistry).size() > 0) {
            stringArray = map.keySet().toArray(new String[map.size()]);
            for (n = 0; n < stringArray.length; ++n) {
                objectArray = (Object[])map.get(stringArray[n]);
                this.playSE(stringArray[n], (String)objectArray[0], (Boolean)objectArray[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Logger.prepare();
        if (stringArray.length < 1) {
            System.err.println("\u306b\u3087\u308f\u30fc");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.err.println("\u306d\u3047\u305e\u3054\u3089\u3041\uff01");
            return;
        }
        boolean bl = false;
        if (stringArray.length >= 2) {
            bl = stringArray[1].equals("loop");
        }
        long l = -1L;
        if (stringArray.length >= 3) {
            l = Long.parseLong(stringArray[2]);
        }
        SampledAudioClip sampledAudioClip = new SampledAudioClip("hoge", file.toURL());
        sampledAudioClip.play(bl);
        if (l > 0L) {
            SampledAudioClip sampledAudioClip2 = sampledAudioClip;
            synchronized (sampledAudioClip2) {
                sampledAudioClip.wait(l);
            }
            ((AudioClip)sampledAudioClip).stop();
        }
    }
}

