/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Image;
import java.io.Serializable;
import tsukuba_bunko.peko.canvas.stage.ImageManager;

public class Actor
implements Serializable {
    public static final int POSITION_CENTER = 0;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_ABSOLUTE = 3;
    private String _name = null;
    private String _looks = null;
    private transient Image _looksImage = null;
    private int _position = 0;
    private float _absolutePosition = 0.0f;

    public Actor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is not specified.");
        }
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setLooks(String string) {
        ImageManager imageManager = ImageManager.getInstance();
        if (this._looks != null && this._looks.equals(string)) {
            if (this._looksImage == null) {
                this.setLooksImage(imageManager.getImage(string, true));
            }
        } else {
            if (this._looksImage != null) {
                imageManager.putImage(this._looks, this._looksImage);
            }
            this.setLooksImage(imageManager.getImage(string, true));
        }
        this._looks = string;
    }

    public String getLooks() {
        return this._looks;
    }

    public void setLooksImage(Image image) {
        this._looksImage = image;
    }

    public Image getLooksImage() {
        return this._looksImage;
    }

    public void setPosition(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid position type is specified.");
        }
        this._position = n;
    }

    public void setPosition(float f) {
        this._position = 3;
        this._absolutePosition = f;
    }

    public int getPosition() {
        return this._position;
    }

    public float getAbsolutePosition() {
        return this._absolutePosition;
    }

    void disposeLooks() {
        if (this._looksImage != null) {
            ImageManager imageManager = ImageManager.getInstance();
            imageManager.putImage(this._looks, this._looksImage);
            this._looksImage = null;
        }
    }

    void prepare() {
        this.setLooks(this._looks);
    }

    public void copyTo(Actor actor) {
        actor._name = this._name;
        actor._looksImage = this._looksImage;
        actor._looks = this._looks;
        actor._position = this._position;
        actor._absolutePosition = this._absolutePosition;
    }
}

