/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.select;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.select.SelectCanvas;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.text.Line;

public class SelectItemButton
extends JComponent
implements MouseListener {
    public static final String STYLE_WIDTH = "select.button.witdth";
    public static final String STYLE_BACKGROUND_COLOR = "select.button.background.color";
    public static final String STYLE_BACKGROUND_TRANSPARENCY = "select.button.background.transparency";
    public static final String STYLE_FOREGROUND_SELECTED = "select.button.foreground.selected";
    public static final String STYLE_FOREGROUND_UNSELECTED = "select.button.foreground.unselected";
    public static final String STYLE_FOREGROUND_SHADOW = "select.button.foreground.shadow";
    public static final String STYLE_FONT = "select.button.font";
    private SelectCanvas _owner = null;
    private SelectItem _item = null;
    private List _lines = null;
    private Color _foregroundActive = null;
    private Color _foregroundNonActive = null;
    private Color _shadow = null;
    private AlphaComposite _alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    private boolean _selected = false;
    private Dimension _size = new Dimension();

    public SelectItemButton(SelectCanvas selectCanvas) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseListener(this);
        this._owner = selectCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        super.addNotify();
        SelectItemButton selectItemButton = this;
        synchronized (selectItemButton) {
            this.notify();
        }
    }

    public void setSelectItem(SelectItem selectItem) {
        this._item = selectItem;
    }

    public SelectItem getSelectItem() {
        return this._item;
    }

    public void prepare(Map map) {
        Font font;
        Color color = (Color)map.get(STYLE_FOREGROUND_SELECTED);
        this._foregroundActive = color != null ? color : Color.white;
        color = (Color)map.get(STYLE_FOREGROUND_UNSELECTED);
        this._foregroundNonActive = color != null ? color : Color.darkGray;
        color = (Color)map.get(STYLE_BACKGROUND_COLOR);
        if (color != null) {
            this.setBackground(color);
        } else {
            this.setBackground(Color.black);
        }
        color = (Color)map.get(STYLE_FOREGROUND_SHADOW);
        this._shadow = color != null ? color : Color.black;
        this.setForeground(this._foregroundNonActive);
        Float f = (Float)map.get(STYLE_BACKGROUND_TRANSPARENCY);
        if (f != null) {
            if (f.floatValue() != this._alphaComposite.getAlpha()) {
                this._alphaComposite = AlphaComposite.getInstance(3, f.floatValue());
            }
        } else if (this._alphaComposite.getAlpha() != 0.5f) {
            this._alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        }
        float f2 = 320.0f;
        Integer n = (Integer)map.get(STYLE_WIDTH);
        if (n != null) {
            f2 = n.floatValue();
        }
        if ((font = (Font)map.get(STYLE_FONT)) != null) {
            this.setFont(font);
        }
        this.prepareLabel(f2, 2);
    }

    public void prepareLabel(float f, int n) {
        if (this._item == null) {
            Logger.error("[canvas.text] not specified corresponding SelectItem.");
            return;
        }
        Graphics2D graphics2D = (Graphics2D)PekoSystem.getInstance().getMainWindow().getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<Line> arrayList = new ArrayList<Line>();
        float f2 = f - 10.0f;
        float f3 = 0.0f;
        String string = this._item.getText();
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, this.getFont());
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), graphics2D.getFontRenderContext());
        int n2 = string.length();
        Line line = null;
        for (int i = 0; i < n && lineBreakMeasurer.getPosition() < n2; ++i) {
            line = new Line();
            line.setTextLayout(lineBreakMeasurer.nextLayout(f));
            line.setShadowColor(this._shadow);
            arrayList.add(line);
            f3 += line.getAscent();
            f3 += line.getDescent();
        }
        this._lines = arrayList;
        Dimension dimension = new Dimension((int)f, (int)f3 + 10);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public void setSelected(boolean bl) {
        if (this._selected == bl) {
            return;
        }
        if (bl) {
            this.setForeground(this._foregroundActive);
            this._owner.itemSelecting(this);
        } else {
            this.setForeground(this._foregroundNonActive);
            this._owner.itemDeselected(this);
        }
        this._selected = bl;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(this._alphaComposite);
        graphics2D.setColor(this.getBackground());
        Dimension dimension = this.getSize(this._size);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        List list = this._lines;
        if (list != null) {
            graphics2D = (Graphics2D)graphics;
            int n = list.size();
            float f = 5.0f;
            float f2 = 5.0f;
            Line line = null;
            for (int i = 0; i < n; ++i) {
                line = (Line)list.get(i);
                line.setForeground(this.getForeground());
                line.draw(graphics2D, f, f2 += line.getAscent());
                f2 += line.getDescent();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setSelected(true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setSelected(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._selected && mouseEvent.getModifiers() == 16) {
            this._owner.itemSelected(this);
        }
    }
}

