/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.MessageIDs;
import tsukuba_bunko.peko.canvas.select.SelectCanvas;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.stage.Stage;
import tsukuba_bunko.peko.canvas.stage.StageCanvas;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.canvas.text.TextCanvas;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.Session;

public class CanvasManager {
    private TextCanvas _text = null;
    private StageCanvas _stage = null;
    private SelectCanvas _select = null;
    private List _history = null;
    private int _maxHistoryCount = 0;
    private Page _currentPage = null;
    private boolean _selecting = false;
    private Map _selectStyle = null;
    private Map _titleStyle = null;

    public void initialize() {
        PekoSystem pekoSystem = PekoSystem.getInstance();
        ResourceManager resourceManager = ResourceManager.getInstance();
        this._history = new ArrayList();
        JFrame jFrame = pekoSystem.getMainWindow();
        String string = (String)resourceManager.getResource("game-info.title");
        Dimension dimension = (Dimension)resourceManager.getResource("peko.canvas.canvas-size");
        ImageIcon imageIcon = (ImageIcon)resourceManager.getResource("game-info.icon");
        jFrame.setTitle(string);
        if (imageIcon.getIconHeight() > 0 && imageIcon.getIconWidth() > 0) {
            jFrame.setIconImage(imageIcon.getImage());
        }
        jFrame.setResizable(true);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setPreferredSize(dimension);
        jComponent.setSize(dimension);
        jComponent.setLayout(null);
        this._stage = new StageCanvas();
        this._stage.setStage(new Stage());
        jComponent.add(this._stage);
        this._stage.setLocation(0, 0);
        this._text = new TextCanvas();
        this._text.setPreferredSize(dimension);
        this._text.setSize(dimension);
        this._text.setVisible(false);
        this._stage.add(this._text);
        this._text.setLocation(0, 0);
        this._select = new SelectCanvas();
        this._select.setPreferredSize(dimension);
        this._select.setSize(dimension);
        this._select.setVisible(false);
        this._stage.add(this._select);
        this._select.setLocation(0, 0);
        jFrame.addKeyListener(this._select);
        Integer n = (Integer)resourceManager.getResource("peko.canvas.text-history");
        this._maxHistoryCount = n == null ? 10 : n;
        this.initializeSelectStyle();
        this.initializeTitleStyle();
    }

    protected void initializeSelectStyle() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        this._selectStyle = new HashMap(17);
        Color color = (Color)resourceManager.getResource("peko.canvas.select.button.background.color");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.color", "black"});
            color = Color.black;
        }
        this._selectStyle.put("select.button.background.color", color);
        Float f = (Float)resourceManager.getResource("peko.canvas.select.button.background.transparency");
        if (f == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            f = new Float(0.5f);
        } else if (f.floatValue() < 0.0f) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            f = new Float(0.5f);
        }
        this._selectStyle.put("select.button.background.transparency", f);
        Integer n = (Integer)resourceManager.getResource("peko.canvas.select.button.width");
        if (n == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.witdth", "320"});
            n = new Integer(320);
        }
        this._selectStyle.put("select.button.witdth", n);
        color = (Color)resourceManager.getResource("peko.canvas.select.button.foreground.selected");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.selected", "white"});
            color = Color.white;
        }
        this._selectStyle.put("select.button.foreground.selected", color);
        color = (Color)resourceManager.getResource("peko.canvas.select.button.foreground.unselected");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.unselected", "darkGray"});
            color = Color.darkGray;
        }
        this._selectStyle.put("select.button.foreground.unselected", color);
        color = (Color)resourceManager.getResource("peko.canvas.select.button.foreground.shadow");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.shadow", "black"});
            color = Color.black;
        }
        this._selectStyle.put("select.button.foreground.shadow", color);
        Font font = (Font)resourceManager.getResource("peko.canvas.select.button.font");
        if (font == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(17);
            hashMap.put(TextAttribute.FAMILY, "SansSerif");
            hashMap.put(TextAttribute.SIZE, new Float(16.0f));
            font = FontManager.getInstance().getFont(hashMap);
        }
        this._selectStyle.put("select.button.font", font);
    }

    protected void initializeTitleStyle() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        this._titleStyle = new HashMap(17);
        Color color = (Color)resourceManager.getResource("peko.title.style.button.background.color");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.color", "black"});
            color = Color.black;
        }
        this._titleStyle.put("select.button.background.color", color);
        Float f = (Float)resourceManager.getResource("peko.title.style.button.background.transparency");
        if (f == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            f = new Float(0.5f);
        } else if (f.floatValue() < 0.0f) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            f = new Float(0.5f);
        }
        this._titleStyle.put("select.button.background.transparency", f);
        Integer n = (Integer)resourceManager.getResource("peko.title.style.button.width");
        if (n == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.witdth", "320"});
            n = new Integer(320);
        }
        this._titleStyle.put("select.button.witdth", n);
        color = (Color)resourceManager.getResource("peko.title.style.button.foreground.selected");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.selected", "white"});
            color = Color.white;
        }
        this._titleStyle.put("select.button.foreground.selected", color);
        color = (Color)resourceManager.getResource("peko.title.style.button.foreground.unselected");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.unselected", "darkGray"});
            color = Color.darkGray;
        }
        this._titleStyle.put("select.button.foreground.unselected", color);
        color = (Color)resourceManager.getResource("peko.title.style.button.foreground.shadow");
        if (color == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.shadow", "black"});
            color = Color.black;
        }
        this._titleStyle.put("select.button.foreground.shadow", color);
        Font font = (Font)resourceManager.getResource("peko.title.style.button.font");
        if (font == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(17);
            hashMap.put(TextAttribute.FAMILY, "SansSerif");
            hashMap.put(TextAttribute.SIZE, new Float(16.0f));
            font = FontManager.getInstance().getFont(hashMap);
        }
        this._titleStyle.put("select.button.font", font);
    }

    public TextCanvas getTextCanvas() {
        return this._text;
    }

    public StageCanvas getStageCanvas() {
        return this._stage;
    }

    public Stage getStage() {
        return this._stage.getStage();
    }

    public Page getCurrentPage() {
        return this._text.getPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page advancesNewPage() {
        Page page = this._text.getPage();
        if (page != null) {
            Page page2 = page;
            synchronized (page2) {
                this.putTextHistory(page);
                page.clearLines();
            }
        } else {
            page = new Page();
            this._text.setPage(page);
        }
        this._currentPage = page;
        return page;
    }

    protected void putTextHistory(Page page) {
        if (page.getLineCount() == 0) {
            return;
        }
        Page page2 = null;
        if (this._history.size() >= this._maxHistoryCount) {
            page2 = (Page)this._history.remove(0);
            page.clone(page2);
        } else {
            page2 = (Page)page.clone();
        }
        this._history.add(page2);
    }

    public boolean readAgain(int n) {
        if (this._selecting) {
            this._select.setVisible(false);
        }
        Page page = (Page)this._history.get(this._history.size() - n);
        this._text.setPage(page);
        this._text.updateCanvas();
        this._text.updateText();
        return this._history.size() - n > 0;
    }

    public void returnCurrent() {
        this._text.setPage(this._currentPage);
        this._text.updateCanvas();
        this._text.updateText();
        if (this._selecting) {
            this.hideTextCanvas();
            this._select.setVisible(true);
        }
    }

    public int getPageHistoryCount() {
        return this._history.size();
    }

    public boolean isShowingSelect() {
        return this._selecting;
    }

    public String showSelect(List list) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        String string = (String)resourceManager.getResource("peko.canvas.select.align");
        if (string == null) {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        } else if ("center".equalsIgnoreCase(string)) {
            this._select.setAlignment(1);
        } else if ("left".equalsIgnoreCase(string)) {
            this._select.setAlignment(0);
        } else if ("right".equalsIgnoreCase(string)) {
            this._select.setAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        }
        String string2 = (String)resourceManager.getResource("peko.canvas.select.vertical-align");
        if (string2 == null) {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"middle"});
            this._select.setVerticalAlignment(1);
        } else if ("top".equalsIgnoreCase(string2)) {
            this._select.setVerticalAlignment(0);
        } else if ("middle".equalsIgnoreCase(string2)) {
            this._select.setVerticalAlignment(1);
        } else if ("bottom".equalsIgnoreCase(string2)) {
            this._select.setVerticalAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"middle"});
            this._select.setVerticalAlignment(1);
        }
        Integer n = (Integer)resourceManager.getResource("peko.canvas.select.columns");
        if (n == null) {
            Logger.warn(MessageIDs.CVS3002W, new Object[]{"1"});
            this._select.setColumns(1);
        } else {
            this._select.setColumns(n);
        }
        Integer n2 = (Integer)resourceManager.getResource("peko.canvas.select.span.column");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3004W, new Object[]{"5"});
            this._select.setColumnSpan(5);
        } else {
            this._select.setColumnSpan(n2);
        }
        n2 = (Integer)resourceManager.getResource("peko.canvas.select.span.row");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3005W, new Object[]{"5"});
            this._select.setRowSpan(5);
        } else {
            this._select.setRowSpan(n2);
        }
        n2 = (Integer)resourceManager.getResource("peko.canvas.select.span.bound");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3007W, new Object[]{"20"});
            this._select.setBoundSpan(20);
        } else {
            this._select.setBoundSpan(n2);
        }
        this._select.setButtonStyle(this._selectStyle);
        boolean bl = this._text.isVisible();
        if (bl) {
            this.hideTextCanvas();
        }
        Page page = this.advancesNewPage();
        page.commit();
        this._selecting = true;
        ActionControler actionControler = PekoSystem.getInstance().getActionControler();
        if (actionControler.getPlayMode() == 1) {
            actionControler.setPlayModeToNormal();
        }
        this._select.setVisible(true);
        String string3 = this._select.select(list);
        this._select.setVisible(false);
        if (bl) {
            this._text.updateText();
        }
        this._selecting = false;
        return string3;
    }

    public String showTitle(boolean bl) {
        String string;
        String string2;
        String string3;
        ResourceManager resourceManager = ResourceManager.getInstance();
        String string4 = (String)resourceManager.getResource("peko.title.style.align");
        if (string4 == null) {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        } else if ("center".equalsIgnoreCase(string4)) {
            this._select.setAlignment(1);
        } else if ("left".equalsIgnoreCase(string4)) {
            this._select.setAlignment(0);
        } else if ("right".equalsIgnoreCase(string4)) {
            this._select.setAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        }
        String string5 = (String)resourceManager.getResource("peko.title.style.vertical-align");
        if (string5 == null) {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"bottom"});
            this._select.setVerticalAlignment(2);
        } else if ("top".equalsIgnoreCase(string5)) {
            this._select.setVerticalAlignment(0);
        } else if ("middle".equalsIgnoreCase(string5)) {
            this._select.setVerticalAlignment(1);
        } else if ("bottom".equalsIgnoreCase(string5)) {
            this._select.setVerticalAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"bottom"});
            this._select.setVerticalAlignment(2);
        }
        Integer n = (Integer)resourceManager.getResource("peko.title.style.columns");
        if (n == null) {
            Logger.warn(MessageIDs.CVS3002W, new Object[]{"1"});
            this._select.setColumns(1);
        } else {
            this._select.setColumns(n);
        }
        String string6 = (String)resourceManager.getResource("peko.title.caption.start");
        if (string6 == null) {
            string6 = "Start";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"start", string6});
        }
        if ((string3 = (String)resourceManager.getResource("peko.title.caption.resume")) == null) {
            string3 = "Load";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"resume", string3});
        }
        if ((string2 = (String)resourceManager.getResource("peko.title.caption.exit")) == null) {
            string2 = "Exit";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"exit", string2});
        }
        this._select.setButtonStyle(this._titleStyle);
        Integer n2 = (Integer)resourceManager.getResource("peko.title.style.span.column");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3004W, new Object[]{"5"});
            this._select.setColumnSpan(5);
        } else {
            this._select.setColumnSpan(n2);
        }
        n2 = (Integer)resourceManager.getResource("peko.title.style.span.row");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3005W, new Object[]{"5"});
            this._select.setRowSpan(5);
        } else {
            this._select.setRowSpan(n2);
        }
        n2 = (Integer)resourceManager.getResource("peko.title.style.span.bound");
        if (n2 == null) {
            Logger.warn(MessageIDs.CVS3007W, new Object[]{"20"});
            this._select.setBoundSpan(20);
        } else {
            this._select.setBoundSpan(n2);
        }
        ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>(3);
        SelectItem selectItem = new SelectItem();
        selectItem.setID("start");
        selectItem.setText(string6);
        arrayList.add(selectItem);
        selectItem = new SelectItem();
        selectItem.setID("resume");
        selectItem.setText(string3);
        arrayList.add(selectItem);
        selectItem = new SelectItem();
        selectItem.setID("exit");
        selectItem.setText(string2);
        arrayList.add(selectItem);
        if (bl) {
            string = (String)resourceManager.getResource("peko.title.image");
            if (string != null && string.length() > 0) {
                this._stage.getStage().setBackgroundImage(string);
            } else {
                this._stage.getStage().setBackgroundColor("white");
            }
            this._stage.updateCanvas("mofing");
            String string7 = (String)resourceManager.getResource("peko.title.bgm", true);
            if (string7 != null && string7.length() > 0) {
                Logger.debug("playBGM: " + string7);
                this._stage.getStage().getAudioPlayer().playBGM("opening", string7, true);
            }
        }
        this.hideTextCanvas();
        this._selecting = true;
        this._select.setVisible(true);
        string = this._select.select(arrayList);
        this._select.setVisible(false);
        this._selecting = false;
        return string;
    }

    public void hideTextCanvas() {
        this._text.setVisible(false);
        this._stage.paintPageBackground(false);
    }

    public void showTextCanvas() {
        this._stage.paintPageBackground(true);
        this._text.setVisible(true);
    }

    public synchronized void clearAll() {
        Logger.debug("[canvas] clear All.");
        this._select.setVisible(false);
        this.hideTextCanvas();
        this._select.cancel();
        this._stage.getStage().getAudioPlayer().stopAll();
        this.advancesNewPage();
        this._text.getPage().commit();
        this._history.clear();
        Stage stage = this._stage.getStage();
        stage.exitAll();
        stage.setBackgroundColor("black");
        stage.hideSlide();
        this._stage.updateCanvas("mofing");
        stage.commit();
    }

    public void resume(Session session) {
        Stage stage = this._stage.getStage();
        stage.setBackgroundColor("black");
        stage.updateCanvas("mofing");
        this._stage.setVisible(false);
        try {
            SerializableForm serializableForm = (SerializableForm)session.getSessionAttribute("canvasManager");
            this._text.setPage(serializableForm.page);
            this._stage.setStage(serializableForm.stage);
            serializableForm.stage.prepare();
            serializableForm.page.rollback();
        }
        catch (Throwable throwable) {
            Logger.fatal("[canvas] unsupported serializable form.", throwable);
        }
        this._stage.setVisible(true);
        this._stage.getStage().getAudioPlayer().prepare();
    }

    public void saveState(Session session) {
        SerializableForm serializableForm = new SerializableForm();
        serializableForm.page = this._text.getPage();
        serializableForm.stage = this._stage.getStage();
        session.setSessionAttribute("canvasManager", serializableForm);
    }

    public static class SerializableForm
    implements Serializable {
        public Stage stage = null;
        public Page page = null;
    }
}

