/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko;

import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.ScenarioProcessor;
import tsukuba_bunko.peko.session.Session;
import tsukuba_bunko.peko.session.SessionManager;

public class PekoSystem {
    private static PekoSystem _instance = null;
    private Object[] _versionInfo = null;
    private JFrame _mainWindow = null;
    private CanvasManager _canvasManager = null;
    private ScenarioProcessor _scenarioProcessor = null;
    private SessionManager _sessionManager = null;
    private ActionControler _actionControler = null;
    private boolean _started = false;
    static /* synthetic */ Class class$tsukuba_bunko$peko$PekoSystem;

    protected PekoSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this._started) {
            return;
        }
        Point point = (Point)this._sessionManager.getSystemSaveData().getEntry("windowLocation");
        if (point != null) {
            this._mainWindow.setLocation(point);
        } else {
            this._mainWindow.setLocationRelativeTo(null);
        }
        this._mainWindow.show();
        JFrame jFrame = this._mainWindow;
        synchronized (jFrame) {
            try {
                if (!this._mainWindow.isShowing()) {
                    this._mainWindow.wait();
                    Logger.debug("[system] window opened.");
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.debug("[system] interrupted in waiting for opening window.");
            }
        }
        this._actionControler.returnTitle(true);
    }

    public void exit() {
        boolean bl = this._actionControler.isActive();
        this._actionControler.setActive(false);
        ResourceManager resourceManager = ResourceManager.getInstance();
        String string = (String)resourceManager.getResource("peko.dialog.exit.title");
        String string2 = (String)resourceManager.getResource("peko.dialog.exit.message");
        if (0 != JOptionPane.showConfirmDialog(this._mainWindow, string2, string, 2)) {
            this._actionControler.setActive(bl);
            return;
        }
        this._mainWindow.dispose();
        try {
            this._sessionManager.getSystemSaveData().addEntry("windowLocation", this._mainWindow.getLocation());
            this._sessionManager.saveSystemSaveData();
        }
        catch (Exception exception) {
            PekoSystem.showErrorDialog("fail to system save data.", exception, false);
        }
        Logger.info("Bye!");
        System.exit(0);
    }

    public void showTitle() {
        try {
            if (this._started) {
                this._scenarioProcessor.exit();
                this._canvasManager.clearAll();
            } else {
                this._canvasManager.getStageCanvas().setUsingEffect(false);
                this._canvasManager.clearAll();
                this._canvasManager.getStageCanvas().setUsingEffect(true);
                this._started = true;
            }
            this._mainWindow.setTitle((String)ResourceManager.getInstance().getResource("game-info.title"));
            boolean bl = true;
            while (true) {
                String string;
                if ((string = this._canvasManager.showTitle(bl)) == null) {
                    Logger.debug("[system] canceled.");
                    break;
                }
                if ("start".equals(string)) {
                    ResourceManager resourceManager = ResourceManager.getInstance();
                    String string2 = (String)resourceManager.getResource("peko.system.start-scene");
                    if (string2 == null) {
                        Logger.fatal("[system] not specified scenario.start-scene.");
                        throw new InitializationError("[system] not specified scenario.start-scene.");
                    }
                    this._canvasManager.clearAll();
                    this._sessionManager.initializeSession();
                    this._scenarioProcessor.playScenario(string2, this._sessionManager.getSession());
                    break;
                }
                if ("resume".equals(string)) {
                    if (this.load()) {
                        break;
                    }
                } else if ("exit".equals(string)) {
                    this.exit();
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)exception);
            JOptionPane.showMessageDialog(this._mainWindow, "ERROR!", "Error!", 0);
        }
    }

    public void save() {
        try {
            Session session = this._sessionManager.getSession();
            this._canvasManager.saveState(session);
            this._sessionManager.saveCurrentSession();
        }
        catch (Exception exception) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)exception);
            JOptionPane.showMessageDialog(this._mainWindow, "[system] fatal error occured during saving states.", "Error!", 0);
            return;
        }
        try {
            this._sessionManager.saveSystemSaveData();
        }
        catch (Exception exception) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)exception);
            PekoSystem.showErrorDialog("A fatal error occured during saving states", exception, true);
        }
    }

    public boolean load() {
        boolean bl = false;
        try {
            this._actionControler.setPlayModeToNormal();
            if (this._sessionManager.load()) {
                this._scenarioProcessor.exit();
                this._canvasManager.clearAll();
                Session session = this._sessionManager.getSession();
                this._mainWindow.setTitle(session.getSceneContext().getSceneTitle() + " - " + ResourceManager.getInstance().getResource("game-info.title"));
                this._canvasManager.resume(session);
                this._scenarioProcessor.playScenario(session.getSceneContext().getSceneName(), session);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            Logger.fatal("[system] fatal error occured during saving states.", (Throwable)exception);
            JOptionPane.showMessageDialog(this._mainWindow, "[system] fatal error occured during saving states.", "Error!", 0);
        }
        return bl;
    }

    public void showSystemVersionInfo() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        ImageIcon imageIcon = null;
        URL uRL = this.getClass().getClassLoader().getResource("pvns-logo.gif");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL, "PVNS Logo");
        }
        JOptionPane.showMessageDialog(this._mainWindow, this._versionInfo, (String)this._versionInfo[0], 1, imageIcon);
    }

    public void showGameVersionInfo() {
        ResourceManager resourceManager = ResourceManager.getInstance();
        Icon icon = (Icon)resourceManager.getResource("game-info.logo", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{"game-info.title", "game-info.version", "game-info.publisher", "game-info.copyright"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)resourceManager.getResource(stringArray[i], true);
            if (string == null) continue;
            arrayList.add(string);
        }
        List list = (List)resourceManager.getResource("game-info.additional-info", true);
        if (list != null && !list.isEmpty()) {
            if (!arrayList.isEmpty()) {
                arrayList.add(" ");
            }
            arrayList.addAll(list);
        }
        if (!arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(this._mainWindow, arrayList.toArray(), (String)resourceManager.getResource("game-info.title"), 1, icon);
        }
    }

    public Object[] getPekoSystemVersion() {
        return this._versionInfo;
    }

    public JFrame getMainWindow() {
        return this._mainWindow;
    }

    public CanvasManager getCanvasManager() {
        return this._canvasManager;
    }

    public ActionControler getActionControler() {
        return this._actionControler;
    }

    private void prepareVersionInfo() {
        try {
            InputStream inputStream = (class$tsukuba_bunko$peko$PekoSystem == null ? (class$tsukuba_bunko$peko$PekoSystem = PekoSystem.class$("tsukuba_bunko.peko.PekoSystem")) : class$tsukuba_bunko$peko$PekoSystem).getResourceAsStream("version.txt");
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "Shift_JIS"));
                String string = bufferedReader.readLine();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (string != null) {
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                inputStream.close();
                this._versionInfo = arrayList.toArray();
            } else {
                Logger.error("[system] missing version.txt.");
                Logger.debug("[system] using embeded version info.");
                this._versionInfo = new Object[]{"\"Peko\" Visual Novel System", "version 1.0", "All Rights Reserved.", "(c)Copyright by Tsukuba Bunko."};
            }
        }
        catch (IOException iOException) {
            Logger.error("[system] fail to read version info.", (Throwable)iOException);
            Logger.debug("[system] using embeded version info.");
            this._versionInfo = new Object[]{"\"Peko\" Visual Novel System", "version 1.0", "All Rights Reserved.", "(c)Copyright by Tsukuba Bunko."};
        }
    }

    private void prepareMainWindow() {
        JFrame jFrame;
        this._mainWindow = jFrame = new JFrame((String)this._versionInfo[0]);
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowOpened(WindowEvent windowEvent) {
                JFrame jFrame = PekoSystem.this._mainWindow;
                synchronized (jFrame) {
                    PekoSystem.this._mainWindow.notify();
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                PekoSystem.this.exit();
            }
        });
    }

    private void prepareResources() {
        try {
            ResourceManager resourceManager = ResourceManager.getInstance();
        }
        catch (Exception exception) {
            throw new InitializationError();
        }
    }

    private void prepareCanvasManager() {
        this._canvasManager = new CanvasManager();
        this._canvasManager.initialize();
    }

    private void prepareScenarioProcessor() {
        this._scenarioProcessor = new ScenarioProcessor();
    }

    private void prepareSessionManager() {
        this._sessionManager = new SessionManager();
    }

    private void prepareActionControler() {
        ActionControler actionControler = new ActionControler();
        this._canvasManager.getTextCanvas().addMouseListener(actionControler);
        this._canvasManager.getStageCanvas().addMouseListener(actionControler);
        this._mainWindow.addKeyListener(actionControler);
        this._actionControler = actionControler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PekoSystem getInstance() {
        if (_instance == null) {
            Class clazz = class$tsukuba_bunko$peko$PekoSystem == null ? (class$tsukuba_bunko$peko$PekoSystem = PekoSystem.class$("tsukuba_bunko.peko.PekoSystem")) : class$tsukuba_bunko$peko$PekoSystem;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new PekoSystem();
                    _instance.prepareVersionInfo();
                    _instance.prepareResources();
                    _instance.prepareSessionManager();
                    _instance.prepareMainWindow();
                    _instance.prepareCanvasManager();
                    _instance.prepareActionControler();
                    _instance.prepareScenarioProcessor();
                }
            }
        }
        return _instance;
    }

    public static void showErrorDialog(String string, Throwable throwable, boolean bl) {
        if (string == null) {
            string = throwable.getMessage();
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Object[] objectArray = new Object[stackTraceElementArray.length + 2];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            objectArray[i + 1] = stackTraceElementArray[i];
        }
        objectArray[0] = "Fatal Error :" + string;
        objectArray[1] = throwable.getClass().getName() + " : " + throwable.getMessage();
        JOptionPane.showMessageDialog(null, objectArray, "FATAL ERROR ! -\"Peko\" Visual Novel System", 0);
        if (bl) {
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Logger.prepare();
        try {
            PekoSystem pekoSystem = PekoSystem.getInstance();
            Object[] objectArray = pekoSystem.getPekoSystemVersion();
            Logger.info((String)objectArray[0]);
            Logger.info((String)objectArray[1]);
            pekoSystem.start();
        }
        catch (Throwable throwable) {
            PekoSystem.showErrorDialog(null, throwable, true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

