/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.TextHistoryControler;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.util.GenericListener;

public class ActionControler
implements KeyListener,
MouseListener {
    public static final long SM_DEFAULT = -1L;
    public static final long SM_NONSTOP = 0L;
    public static final int PM_SKIP = 1;
    public static final int PM_NORMAL = 0;
    public static final int PM_AUTOMATIC = 2;
    private Object _lock = this;
    private boolean _activity = false;
    private int _playMode = -1;
    private JMenuItem[] _buttons = new JMenuItem[3];
    private JMenuItem _usingEffectMenu = null;
    private JMenuItem _saveMenu = null;
    private JMenuItem _loadMenu = null;
    private JMenuItem _returnTileMenu = null;
    private JMenuItem _readAgainMenu = null;
    private Timer _timer = new Timer(true);
    private TimerTask _lastTask = null;
    private TextHistoryControler _readAgainControler = null;
    private int _lastKeyCode = -1;
    private boolean _waitingActivate = false;
    private boolean _hiddenText = false;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ActionControler() {
        this.prepareMenuBar();
        this.setPlayModeToNormal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean bl) {
        this._activity = bl;
        if (!bl) {
            this._lastKeyCode = -1;
        } else if (this._playMode != 0 && this._waitingActivate) {
            Object object = this._lock;
            synchronized (object) {
                if (this._waitingActivate) {
                    this._lock.notify();
                }
            }
        }
    }

    public boolean isActive() {
        return this._activity && !PekoSystem.getInstance().getCanvasManager().isShowingSelect();
    }

    public synchronized void setSaveEnabled(boolean bl) {
        this._saveMenu.setEnabled(bl);
    }

    public int getPlayMode() {
        return this._playMode;
    }

    protected void setPlayMode(int n) {
        this._playMode = n;
        this._buttons[n].setSelected(true);
        if (n == 1) {
            this._readAgainMenu.setEnabled(false);
        } else if (!this._readAgainMenu.isEnabled()) {
            this._readAgainMenu.setEnabled(true);
        }
        PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect(!this._usingEffectMenu.isSelected() && n != 1);
        if (this._playMode != 0 && !PekoSystem.getInstance().getCanvasManager().isShowingSelect()) {
            this.start();
        }
    }

    public void setPlayModeToSKip() {
        this.setPlayMode(1);
    }

    public void setPlayModeToNormal() {
        this.setPlayMode(0);
    }

    public void setPlayModeToAutomatic() {
        this.setPlayMode(2);
    }

    public void changeUsingEffect() {
        PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect(!this._usingEffectMenu.isSelected() && this._playMode != 1);
    }

    public void showReadAgain() {
        this.setActive(false);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(false);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        if (this._readAgainControler == null) {
            this._readAgainControler = new TextHistoryControler();
            this._readAgainControler.setLocationRelativeTo(PekoSystem.getInstance().getMainWindow());
        }
        this._readAgainControler.show();
        this.setActive(true);
        this._saveMenu.setEnabled(true);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
    }

    public void showLoadDialog() {
        this.setActive(false);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(false);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        PekoSystem pekoSystem = PekoSystem.getInstance();
        if (!pekoSystem.load()) {
            this.setActive(true);
        }
        this._saveMenu.setEnabled(true);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
    }

    public synchronized void showSaveDialog() {
        PekoSystem pekoSystem = PekoSystem.getInstance();
        this.setActive(false);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(false);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        pekoSystem.save();
        this._saveMenu.setEnabled(true);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
        this.setActive(true);
    }

    public void returnTitle() {
        this.returnTitle(false);
    }

    public void returnTitle(boolean bl) {
        this.setActive(false);
        this.setPlayMode(0);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(false);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        if (bl) {
            PekoSystem.getInstance().showTitle();
        } else {
            String string;
            ResourceManager resourceManager = ResourceManager.getInstance();
            String string2 = (String)resourceManager.getResource("peko.dialog.return-title.message");
            if (string2 == null) {
                string2 = "Are you return title ?";
            }
            if ((string = (String)resourceManager.getResource("peko.dialog.return-title.title")) == null) {
                string = "Confirm";
            }
            if (0 == JOptionPane.showConfirmDialog(PekoSystem.getInstance().getMainWindow(), string2, string, 2)) {
                PekoSystem.getInstance().showTitle();
            } else {
                this.setActive(true);
            }
        }
        this._saveMenu.setEnabled(true);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._lastTask != null) {
                this._lastTask.cancel();
            }
            this._lastTask = null;
            this._lock.notify();
            Logger.debug("[system.controler] notify to finish wait.");
        }
    }

    public void stop() {
        this.stop(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long l) {
        Object object;
        Logger.debug("[system.controler] stop :" + l);
        if (l != 0L && this._playMode != 1) {
            if (l < 0L) {
                object = this._lock;
                synchronized (object) {
                    try {
                        if (this._playMode == 2 && !PekoSystem.getInstance().getCanvasManager().isShowingSelect()) {
                            TimerTask timerTask = new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    Object object = ActionControler.this._lock;
                                    synchronized (object) {
                                        ActionControler.this._lock.notify();
                                    }
                                }
                            };
                            this._timer.schedule(timerTask, 1000L);
                            this._lastTask = timerTask;
                        }
                        this._lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.debug("[system.action] interrupted.");
                    }
                }
            }
            object = this._lock;
            synchronized (object) {
                try {
                    TimerTask timerTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = ActionControler.this._lock;
                            synchronized (object) {
                                ActionControler.this._lock.notify();
                            }
                        }
                    };
                    this._timer.schedule(timerTask, l);
                    this._lastTask = timerTask;
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Logger.debug("[system.action] interrupted.");
                }
            }
        }
        if (!this.isActive() && this._lastTask != null) {
            object = this._lock;
            synchronized (object) {
                if (!this._activity && this._lastTask != null) {
                    this._waitingActivate = true;
                    try {
                        this._lock.wait();
                        this._lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._waitingActivate = false;
                }
            }
        }
        this._lastTask = null;
        Logger.debug("[system.controler] finish wait.");
    }

    private void prepareMenuBar() {
        PekoSystem pekoSystem = PekoSystem.getInstance();
        ResourceManager resourceManager = ResourceManager.getInstance();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        jMenu = new JMenu((String)resourceManager.getResource("peko.menu.system.menu-caption"));
        jMenu.setMnemonic('S');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.system.save"));
        jMenuItem.setEnabled(false);
        jMenuItem.setMnemonic('S');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "showSaveDialog", true);
        jMenu.add(jMenuItem);
        this._saveMenu = jMenuItem;
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.system.load"));
        jMenuItem.setEnabled(false);
        jMenuItem.setMnemonic('O');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "showLoadDialog", true);
        jMenu.add(jMenuItem);
        this._loadMenu = jMenuItem;
        jMenu.addSeparator();
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.system.return-title"));
        jMenuItem.setEnabled(false);
        jMenuItem.setMnemonic('T');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "returnTitle", true);
        jMenu.add(jMenuItem);
        this._returnTileMenu = jMenuItem;
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.system.read-again"));
        jMenuItem.setEnabled(false);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        jMenuItem.setMnemonic('R');
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "showReadAgain");
        jMenu.add(jMenuItem);
        this._readAgainMenu = jMenuItem;
        jMenu.addSeparator();
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.system.exit"));
        jMenuItem.setMnemonic('X');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        GenericListener.connect(jMenuItem, pekoSystem, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "exit");
        jMenu.add(jMenuItem);
        jMenu = new JMenu((String)resourceManager.getResource("peko.menu.config.menu-caption"));
        jMenu.setMnemonic('C');
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu((String)resourceManager.getResource("peko.menu.config.playmode.menu-caption"));
        jMenu2.setMnemonic('P');
        jMenu.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItem((String)resourceManager.getResource("peko.menu.config.playmode.normal"));
        jMenuItem.setMnemonic('N');
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "setPlayModeToNormal");
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        this._buttons[0] = jMenuItem;
        jMenuItem = new JRadioButtonMenuItem((String)resourceManager.getResource("peko.menu.config.playmode.automatic"));
        jMenuItem.setMnemonic('A');
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "setPlayModeToAutomatic");
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        this._buttons[2] = jMenuItem;
        jMenuItem = new JRadioButtonMenuItem((String)resourceManager.getResource("peko.menu.config.playmode.skip"));
        jMenuItem.setMnemonic('S');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "setPlayModeToSKip");
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenuItem);
        this._buttons[1] = jMenuItem;
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem((String)resourceManager.getResource("peko.menu.config.use-effect"));
        jMenuItem.setSelected(false);
        jMenuItem.setMnemonic('E');
        GenericListener.connect(jMenuItem, this, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "changeUsingEffect");
        jMenu.add(jMenuItem);
        this._usingEffectMenu = jMenuItem;
        jMenu = new JMenu((String)resourceManager.getResource("peko.menu.help.menu-caption"));
        jMenu.setMnemonic('H');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.help.help-contents"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem.setMnemonic('H');
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.help.version"));
        jMenuItem.setMnemonic('A');
        GenericListener.connect(jMenuItem, pekoSystem, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "showGameVersionInfo");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem((String)resourceManager.getResource("peko.menu.help.about-pvns"));
        jMenuItem.setMnemonic('P');
        GenericListener.connect(jMenuItem, pekoSystem, class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ActionControler.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, "actionPerformed", "showSystemVersionInfo");
        jMenu.add(jMenuItem);
        JFrame jFrame = pekoSystem.getMainWindow();
        jFrame.setJMenuBar(jMenuBar);
        jFrame.pack();
        jFrame.setResizable(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (this.isActive() && n == 16) {
            this.start();
        } else {
            if (this._playMode == 1 && n == 4) {
                this.setPlayModeToNormal();
                return;
            }
            if (this._hiddenText) {
                CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
                canvasManager.hideTextCanvas();
                this.setActive(true);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isActive()) {
            int n = keyEvent.getKeyCode();
            if (this._lastKeyCode == -1) {
                this._lastKeyCode = n;
            } else if (this._lastKeyCode != n) {
                this._lastKeyCode = -1;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != this._lastKeyCode) {
            this._lastKeyCode = -1;
            return;
        }
        if (this._hiddenText) {
            CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
            canvasManager.showTextCanvas();
            this._saveMenu.setEnabled(true);
            this._loadMenu.setEnabled(true);
            this._returnTileMenu.setEnabled(true);
            this._hiddenText = false;
        } else if (this.isActive() && n == 10) {
            this.start();
        } else if (this._playMode != 0 && n == 27) {
            this.setPlayModeToNormal();
        } else if (!this._hiddenText && n == 32) {
            CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
            this._saveMenu.setEnabled(false);
            this._loadMenu.setEnabled(false);
            this._returnTileMenu.setEnabled(false);
            canvasManager.hideTextCanvas();
            this._hiddenText = true;
        }
        this._lastKeyCode = -1;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

