/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlme.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jlme.decoder.BitStream;
import javazoom.jlme.decoder.Decoder;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.SampleBuffer;

public class Player {
    private static Decoder decoder;
    private static SourceDataLine line;
    private BitStream bitstream;
    private boolean playable = true;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public Player(InputStream inputStream) throws Exception {
        this.bitstream = new BitStream(inputStream);
    }

    public static void startOutput(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = Player.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            throw new LineUnavailableException("sorry, the sound format cannot be played");
        }
        line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(audioFormat);
        line.start();
    }

    public static void stopOutput() {
        line.drain();
        line.stop();
        line.close();
    }

    public static void main(String[] stringArray) throws Exception {
        block7: {
            if (stringArray.length > 0) {
                String string = stringArray[0];
                try {
                    if (string.equalsIgnoreCase("-url")) {
                        if (stringArray.length > 1) {
                            URL uRL = new URL(stringArray[1]);
                            Player player = new Player(new BufferedInputStream(uRL.openStream(), 2048));
                            System.out.println("starting");
                            player.play();
                            System.out.println("ending");
                        } else {
                            Player.usage();
                        }
                        break block7;
                    }
                    Player player = new Player(new BufferedInputStream(new FileInputStream(string), 2048));
                    System.out.println("starting");
                    player.play();
                    System.out.println("ending");
                }
                catch (Exception exception) {
                    System.err.println("couldn't locate the mp3 file");
                }
            } else {
                Player.usage();
            }
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Usage : ");
        System.out.println("       java javazoom.jlme.util.Player [mp3file] [-url mp3url]");
        System.out.println("");
        System.out.println("            mp3file : MP3 filename to play");
        System.out.println("            mp3url  : MP3 URL to play");
    }

    public void play() throws Exception {
        boolean bl = true;
        Header header = this.bitstream.readFrame();
        decoder = new Decoder(header, this.bitstream);
        while (this.playable) {
            try {
                SampleBuffer sampleBuffer = decoder.decodeFrame();
                int n = sampleBuffer.size();
                if (n == 0) break;
                if (bl) {
                    bl = false;
                    System.out.println("frequency: " + decoder.getOutputFrequency() + ", channels: " + decoder.getOutputChannels());
                    Player.startOutput(new AudioFormat(decoder.getOutputFrequency(), 16, decoder.getOutputChannels(), true, false));
                }
                line.write(sampleBuffer.getBuffer(), 0, n);
                this.bitstream.closeFrame();
                header = this.bitstream.readFrame();
            }
            catch (Exception exception) {
                break;
            }
        }
        this.playable = false;
        this.bitstream.close();
    }

    public void stop() {
        this.playable = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

