// ------------------------------------------------
// File : stats.cpp
// Date: 4-apr-2002
// Author: giles
// Desc: 
//		Statistic logging
//		
// (c) 2002 peercast.org
// ------------------------------------------------
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------


#include "stats.h"
#include "common.h"
#include "sys.h"

Stats stats;
// ------------------------------------
void Stats::clear()
{
	for(int i=0; i<Stats::MAX; i++)
	{
		current[i] = 0;
		last[i] = 0;
		perSec[i] = 0;
	}
	lastUpdate = 0;
}
// ------------------------------------
void	Stats::update()
{
	unsigned int ctime = sys->getTime();

	unsigned int diff = ctime - lastUpdate;
	if (diff >= 5)
	{
		
		for(int i=0; i<Stats::MAX; i++)
		{
			perSec[i] = (current[i]-last[i])/diff;
			last[i] = current[i];
		}

		lastUpdate = ctime;
	}
	
}


