/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.print.attribute.standard.MediaSizeName;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public final class ResourceUtil {
    private static final String RESOURCE_PATH = pectin.userDir + System.getProperty("file.separator") + "pectin.properties";
    private static Properties pectinProperty = new Properties();
    private static final String FONTSIZE = "fontsize";
    private static final String TABSIZE = "tabsize";
    private static final String COLOR = "color";
    private static final String BACKGROUND = "background";
    private static final String ENDOFLINE = "endofline";
    private static final String WRAP = "wrap";
    private static final String HIGHLIGHTXML = "hxml";
    private static final String HIGHLIGHTEMPTY = "hempty";
    private static final String HIGHLIGHTTAG = "htag";
    private static final int fontSize = 12;
    private static final int tabSize = 4;
    private static final int color = 0;
    private static final int background = 0xFFFFFF;
    private static final String endOfLine = "UNIX";
    private static final int highlightXml = 0x7FFF0000;
    private static final int highlightEmpty = 0x7F00FF00;
    private static final int highlightTag = 0x7F0000FF;
    private static final String PRINTPAPERSIZE = "printpapersize";
    private static final String PRINTFONTSIZE = "printfontsize";
    private static final String PRINTPAPEROPERATION = "printpaperoperation";
    private static final String PRINTTOPMARGIN = "printtopmargin";
    private static final String PRINTBOTTOMMARGIN = "printbottommargin";
    private static final String PRINTLEFTMARGIN = "printleftmargin";
    private static final String PRINTRIGHTMARGIN = "printrightmargin";
    private static final String PRINTLINENUMBER = "printlinenumber";
    private static final String PRINTHEADER = "printheader";
    private static final String PRINTFOOTER = "printfooter";
    private static String printPaperSize = "A4";
    private static int printFontSize = 10;
    private static int printPaperOperation = 1;
    private static double printTopMargin = 25.4;
    private static double printBottomMargin = 25.4;
    private static double printLeftMargin = 25.4;
    private static double printRightMargin = 25.4;
    private static boolean printLineNumber = true;
    private static boolean printHeader = true;
    private static boolean printFooter = true;
    private static final String LOOKANDFEEL = "look_and_feel";
    private static String lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String ENDOFLINE_UNIX = "UNIX";
    public static final String ENDOFLINE_MAC = "MAC";
    public static final String ENDOFLINE_WIN = "WIN";

    private static String getProperty(String key, String defaultValue) {
        return pectinProperty.getProperty(key, defaultValue);
    }

    private static void setProperty(String key, String value) {
        pectinProperty.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getResource() {
        try {
            FileInputStream is = new FileInputStream(RESOURCE_PATH);
            if (is != null) {
                pectinProperty.load(is);
                ((InputStream)is).close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            StaticUtil.errorMessage("\u30ea\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u306e\u5165\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
    }

    public static void putResource() {
        try {
            FileOutputStream os = new FileOutputStream(RESOURCE_PATH);
            if (os != null) {
                pectinProperty.store(os, "pectin");
                ((OutputStream)os).close();
            }
        }
        catch (Exception e) {
            StaticUtil.errorMessage("\u30ea\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
    }

    public static int getFontSize() {
        int size;
        String initStr = String.valueOf(12);
        try {
            size = Integer.parseInt(ResourceUtil.getProperty(FONTSIZE, initStr));
        }
        catch (Exception e) {
            size = 12;
        }
        return size;
    }

    public static int getTabSize() {
        int size;
        String initStr = String.valueOf(4);
        try {
            size = Integer.parseInt(ResourceUtil.getProperty(TABSIZE, initStr));
        }
        catch (Exception e) {
            size = 4;
        }
        return size;
    }

    public static int getColor() {
        int color;
        String initStr = String.valueOf(0);
        try {
            color = Integer.parseInt(ResourceUtil.getProperty(COLOR, initStr));
        }
        catch (Exception e) {
            color = 0;
        }
        return color;
    }

    public static int getBackground() {
        int color;
        String initStr = String.valueOf(0xFFFFFF);
        try {
            color = Integer.parseInt(ResourceUtil.getProperty(BACKGROUND, initStr));
        }
        catch (Exception e) {
            color = 0xFFFFFF;
        }
        return color;
    }

    public static String getEndOfLine() {
        return ResourceUtil.getProperty(ENDOFLINE, "UNIX");
    }

    public static int getHighlightXml() {
        int color;
        String initStr = String.valueOf(0x7FFF0000);
        try {
            color = Integer.parseInt(ResourceUtil.getProperty(HIGHLIGHTXML, initStr));
        }
        catch (Exception e) {
            color = 0x7FFF0000;
        }
        return color;
    }

    public static int getHighlightEmpty() {
        int color;
        String initStr = String.valueOf(0x7F00FF00);
        try {
            color = Integer.parseInt(ResourceUtil.getProperty(HIGHLIGHTEMPTY, initStr));
        }
        catch (Exception e) {
            color = 0x7F00FF00;
        }
        return color;
    }

    public static int getHighlightTag() {
        int color;
        String initStr = String.valueOf(0x7F0000FF);
        try {
            color = Integer.parseInt(ResourceUtil.getProperty(HIGHLIGHTTAG, initStr));
        }
        catch (Exception e) {
            color = 0x7F0000FF;
        }
        return color;
    }

    public static String getLookAndFeel() {
        return ResourceUtil.getProperty(LOOKANDFEEL, lookAndFeel);
    }

    public static void setFontSize(String sizeStr) {
        int size;
        try {
            size = Integer.parseInt(sizeStr);
            if (size < 1) {
                size = 12;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getFontSize();
        }
        ResourceUtil.setProperty(FONTSIZE, String.valueOf(size));
    }

    public static void setTabSize(String sizeStr) {
        int size;
        try {
            size = Integer.parseInt(sizeStr);
            if (size < 1) {
                size = 4;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getTabSize();
        }
        ResourceUtil.setProperty(TABSIZE, String.valueOf(size));
    }

    public static void setColor(int rgb) {
        ResourceUtil.setProperty(COLOR, String.valueOf(rgb));
    }

    public static void setBackground(int rgb) {
        ResourceUtil.setProperty(BACKGROUND, String.valueOf(rgb));
    }

    public static void setEndOfLine(String str) {
        ResourceUtil.setProperty(ENDOFLINE, str);
    }

    public static void setHighlightXml(int srgb) {
        ResourceUtil.setProperty(HIGHLIGHTXML, String.valueOf(srgb));
    }

    public static void setHighlightEmpty(int srgb) {
        ResourceUtil.setProperty(HIGHLIGHTEMPTY, String.valueOf(srgb));
    }

    public static void setHighlightTag(int srgb) {
        ResourceUtil.setProperty(HIGHLIGHTTAG, String.valueOf(srgb));
    }

    public static void setLookAndFeel(String str) {
        ResourceUtil.setProperty(LOOKANDFEEL, str);
    }

    public static MediaSizeName getPrintPaperSize() {
        String sizeName;
        String initStr = printPaperSize;
        try {
            sizeName = ResourceUtil.getProperty(PRINTPAPERSIZE, initStr);
        }
        catch (Exception e) {
            sizeName = printPaperSize;
        }
        sizeName = sizeName.toUpperCase();
        MediaSizeName mediaSize = sizeName.equals("A3") ? MediaSizeName.ISO_A3 : (sizeName.equals("A4") ? MediaSizeName.ISO_A4 : (sizeName.equals("B4") ? MediaSizeName.JIS_B4 : (sizeName.equals("B5") ? MediaSizeName.JIS_B5 : MediaSizeName.ISO_A4)));
        return mediaSize;
    }

    public static void setPrintPaperSize(MediaSizeName mediaSize) {
        String sizeName = "A4";
        if (mediaSize.equals(MediaSizeName.ISO_A3)) {
            sizeName = "A3";
        } else if (mediaSize.equals(MediaSizeName.ISO_A4)) {
            sizeName = "A4";
        } else if (mediaSize.equals(MediaSizeName.JIS_B4)) {
            sizeName = "B4";
        } else if (mediaSize.equals(MediaSizeName.JIS_B5)) {
            sizeName = "B5";
        }
        ResourceUtil.setProperty(PRINTPAPERSIZE, sizeName);
    }

    public static int getPrintFontSize() {
        int size;
        String initStr = String.valueOf(printFontSize);
        try {
            size = Integer.parseInt(ResourceUtil.getProperty(PRINTFONTSIZE, initStr));
        }
        catch (Exception e) {
            size = printFontSize;
        }
        return size;
    }

    public static void setPrintFontSize(String sizeStr) {
        int size;
        try {
            size = Integer.parseInt(sizeStr);
            if (size < 1) {
                size = printFontSize;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getPrintFontSize();
        }
        ResourceUtil.setProperty(PRINTFONTSIZE, String.valueOf(size));
    }

    public static int getPrintPaperOperation() {
        int size;
        String initStr = String.valueOf(printPaperOperation);
        try {
            size = Integer.parseInt(ResourceUtil.getProperty(PRINTPAPEROPERATION, initStr));
        }
        catch (Exception e) {
            size = printPaperOperation;
        }
        return size;
    }

    public static void setPrintPaperOperation(int ope) {
        ResourceUtil.setProperty(PRINTPAPEROPERATION, String.valueOf(ope));
    }

    public static double getPrintTopMargin() {
        double size;
        String initStr = String.valueOf(printTopMargin);
        try {
            size = Double.parseDouble(ResourceUtil.getProperty(PRINTTOPMARGIN, initStr));
        }
        catch (Exception e) {
            size = printTopMargin;
        }
        return size;
    }

    public static void setPrintTopMargin(String sizeStr) {
        double size;
        try {
            size = Double.parseDouble(sizeStr);
            if (size < 0.0) {
                size = printTopMargin;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getPrintTopMargin();
        }
        ResourceUtil.setProperty(PRINTTOPMARGIN, String.valueOf(size));
    }

    public static double getPrintBottomMargin() {
        double size;
        String initStr = String.valueOf(printBottomMargin);
        try {
            size = Double.parseDouble(ResourceUtil.getProperty(PRINTBOTTOMMARGIN, initStr));
        }
        catch (Exception e) {
            size = printBottomMargin;
        }
        return size;
    }

    public static void setPrintBottomMargin(String sizeStr) {
        double size;
        try {
            size = Double.parseDouble(sizeStr);
            if (size < 0.0) {
                size = printBottomMargin;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getPrintBottomMargin();
        }
        ResourceUtil.setProperty(PRINTBOTTOMMARGIN, String.valueOf(size));
    }

    public static double getPrintLeftMargin() {
        double size;
        String initStr = String.valueOf(printLeftMargin);
        try {
            size = Double.parseDouble(ResourceUtil.getProperty(PRINTLEFTMARGIN, initStr));
        }
        catch (Exception e) {
            size = printLeftMargin;
        }
        return size;
    }

    public static void setPrintLeftMargin(String sizeStr) {
        double size;
        try {
            size = Double.parseDouble(sizeStr);
            if (size < 0.0) {
                size = printLeftMargin;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getPrintLeftMargin();
        }
        ResourceUtil.setProperty(PRINTLEFTMARGIN, String.valueOf(size));
    }

    public static double getPrintRightMargin() {
        double size;
        String initStr = String.valueOf(printRightMargin);
        try {
            size = Double.parseDouble(ResourceUtil.getProperty(PRINTRIGHTMARGIN, initStr));
        }
        catch (Exception e) {
            size = printRightMargin;
        }
        return size;
    }

    public static void setPrintRightMargin(String sizeStr) {
        double size;
        try {
            size = Double.parseDouble(sizeStr);
            if (size < 0.0) {
                size = printRightMargin;
            }
        }
        catch (Exception e) {
            size = ResourceUtil.getPrintRightMargin();
        }
        ResourceUtil.setProperty(PRINTRIGHTMARGIN, String.valueOf(size));
    }

    public static boolean getPrintLineNumber() {
        boolean bool;
        String initStr = String.valueOf(printLineNumber);
        try {
            String str = ResourceUtil.getProperty(PRINTLINENUMBER, initStr);
            bool = str.toLowerCase().equals("true");
        }
        catch (Exception e) {
            bool = printLineNumber;
        }
        return bool;
    }

    public static void setPrintLineNumber(boolean bool) {
        ResourceUtil.setProperty(PRINTLINENUMBER, String.valueOf(bool));
    }

    public static boolean getPrintHeader() {
        boolean bool;
        String initStr = String.valueOf(printHeader);
        try {
            String str = ResourceUtil.getProperty(PRINTHEADER, initStr);
            bool = str.toLowerCase().equals("true");
        }
        catch (Exception e) {
            bool = printHeader;
        }
        return bool;
    }

    public static void setPrintHeader(boolean bool) {
        ResourceUtil.setProperty(PRINTHEADER, String.valueOf(bool));
    }

    public static boolean getPrintFooter() {
        boolean bool;
        String initStr = String.valueOf(printFooter);
        try {
            String str = ResourceUtil.getProperty(PRINTFOOTER, initStr);
            bool = str.toLowerCase().equals("true");
        }
        catch (Exception e) {
            bool = printFooter;
        }
        return bool;
    }

    public static void setPrintFooter(boolean bool) {
        ResourceUtil.setProperty(PRINTFOOTER, String.valueOf(bool));
    }
}

