/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.CheckBoxItemListener;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSUrlComponent;

public class PluginGUIListPanel
extends PluginGUICSSAttributePanel {
    private static final String[] LISTSTYLE = new String[]{"disc", "circle", "square", "decimal", "decimal-leading-zero", "lower-roman", "upper-roman", "lower-greek", "lower-alpha", "lower-latin", "upper-alpha", "upper-latin", "hebrew", "armenian", "georgian", "cjk-ideographic", "hiragana", "katakana", "hiragana-iroha", "katakana-iroha", "none", "inherit"};
    private static final String[] POSITION = new String[]{"inside", "outside", "inherit"};
    private JCheckBox styleBtn = new JCheckBox("\u30de\u30fc\u30ab\u30fc\u7a2e\u985e");
    private JCheckBox imageBtn = new JCheckBox("\u30de\u30fc\u30ab\u30fc\u753b\u50cf");
    private JCheckBox positionBtn = new JCheckBox("\u30de\u30fc\u30ab\u30fc\u4f4d\u7f6e");
    private JCheckBox liststyleBtn = new JCheckBox("list-style \u306b\u3088\u308b\u4e00\u62ec\u6307\u5b9a");
    private JComboBox styleBox = new JComboBox<String>(LISTSTYLE);
    private PluginGUICSSUrlComponent imageComp = new PluginGUICSSUrlComponent();
    private JComboBox positionBox = new JComboBox<String>(POSITION);

    public PluginGUIListPanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        this.styleBtn.addItemListener(new CheckBoxItemListener(this.styleBox));
        this.imageBtn.addItemListener(new CheckBoxItemListener(this.imageComp));
        this.positionBtn.addItemListener(new CheckBoxItemListener(this.positionBox));
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel();
        gridPanel.gridLayoutComponent(this.styleBtn, 0, 0);
        gridPanel.gridLayoutComponent(this.styleBox, 1, 0, false);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.imageBtn), 0, 1);
        gridPanel.setWidth(2);
        gridPanel.gridLayoutComponent(this.imageComp, 1, 1, false);
        gridPanel.setWidth(1);
        gridPanel.gridLayoutComponent(this.positionBtn, 0, 2);
        gridPanel.gridLayoutComponent(this.positionBox, 1, 2, false);
        gridPanel.setWidth(2);
        gridPanel.gridLayoutComponent(this.liststyleBtn, 0, 3);
        gridPanel.setWidth(1);
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private String boxString(String name, JComboBox box, boolean flag) {
        StringBuffer buff = flag ? new StringBuffer() : new StringBuffer(name);
        buff.append(" " + (String)box.getSelectedItem());
        if (!flag) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String imageString(boolean flag) {
        StringBuffer buff = flag ? new StringBuffer() : new StringBuffer("\tlist-style-image:");
        buff.append(" " + this.imageComp.getString());
        if (!flag) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        boolean liststyleFlag = false;
        if (this.liststyleBtn.isSelected()) {
            buff.append("\tlist-style:");
            liststyleFlag = true;
        }
        if (this.styleBtn.isSelected()) {
            buff.append(this.boxString("\tlist-style-type:", this.styleBox, liststyleFlag));
        }
        if (this.imageBtn.isSelected()) {
            buff.append(this.imageString(liststyleFlag));
        }
        if (this.positionBtn.isSelected()) {
            buff.append(this.boxString("\tlist-style-position:", this.positionBox, liststyleFlag));
        }
        if (this.liststyleBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    public String toString() {
        return "\u30ea\u30b9\u30c8\u306e\u8a2d\u5b9a";
    }
}

