/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.plugins.PluginGUIXMLAttributePanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginGUIXMLAttributeDialog
extends JDialog
implements WindowListener {
    private Element element;
    private ArrayList attributeArray;
    private ArrayList generalArray;
    private JButton okBtn;
    private JButton cancelBtn;
    private String retString;
    private ArrayList contentPane;

    public PluginGUIXMLAttributeDialog(JFrame frame, Element element, ArrayList attributeArray, ArrayList generalArray) {
        super(frame, "", true);
        this.element = element;
        this.attributeArray = attributeArray;
        this.generalArray = generalArray;
        this.setTitle(element.getAttribute("name") + " \u5c5e\u6027\u8a2d\u5b9a");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public PluginGUIXMLAttributeDialog(JFrame frame, Element element, ArrayList attributeArray) {
        this(frame, element, attributeArray, null);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginGUIXMLAttributeDialog.this.setString();
                PluginGUIXMLAttributeDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginGUIXMLAttributeDialog.this.retString = null;
                PluginGUIXMLAttributeDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private JComponent createContentsPanel() {
        int i;
        this.contentPane = new ArrayList();
        ArrayList<Element> attrList = new ArrayList<Element>();
        for (i = 0; i < this.attributeArray.size(); ++i) {
            Element attrElement = (Element)this.attributeArray.get(i);
            if (attrElement.getAttribute("name").equals("#")) {
                this.contentPane.add(new PluginGUIXMLAttributePanel(this.element, attrList));
                attrList = new ArrayList();
                continue;
            }
            attrList.add(attrElement);
        }
        if (attrList.size() > 0) {
            this.contentPane.add(new PluginGUIXMLAttributePanel(this.element, attrList));
        }
        if (null != this.generalArray) {
            for (i = 0; i < this.generalArray.size(); ++i) {
                ArrayList<Element> attrElementArray = new ArrayList<Element>();
                Element listElement = (Element)this.generalArray.get(i);
                NodeList nodeList = listElement.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node = nodeList.item(j);
                    if (node.getNodeType() != 1 || !node.getNodeName().equals("attribute")) continue;
                    attrElementArray.add((Element)node);
                }
                PluginGUIXMLAttributePanel pane = new PluginGUIXMLAttributePanel(listElement, attrElementArray);
                pane.setTitle(listElement.getAttribute("name"));
                this.contentPane.add(pane);
            }
        }
        if (this.contentPane.size() == 1) {
            return (JPanel)this.contentPane.get(0);
        }
        JTabbedPane tabPane = new JTabbedPane();
        for (int i2 = 0; i2 < this.contentPane.size(); ++i2) {
            String title = ((PluginGUIXMLAttributePanel)this.contentPane.get(i2)).getTitle();
            if (null != title) {
                tabPane.add(title, (JPanel)this.contentPane.get(i2));
                continue;
            }
            tabPane.add("\u57fa\u672c\u8a2d\u5b9a(" + Integer.toString(i2 + 1) + ")", (JPanel)this.contentPane.get(i2));
        }
        return tabPane;
    }

    private void setString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.contentPane.size(); ++i) {
            PluginGUIXMLAttributePanel pan = (PluginGUIXMLAttributePanel)this.contentPane.get(i);
            buff.append(pan.getString());
        }
        this.retString = buff.toString();
    }

    public String getString() {
        return this.retString;
    }

    public void windowClosing(WindowEvent e) {
        this.retString = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    class ButtonActionListener
    implements ActionListener {
        private JTextField field;

        ButtonActionListener(JTextField field) {
            this.field = field;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileDialog = new JFileChooser(System.getProperty("user.dir"));
            if (0 != fileDialog.showOpenDialog(null)) {
                return;
            }
            this.field.setText(fileDialog.getSelectedFile().getPath());
        }
    }

    class CheckBoxItemListener
    implements ItemListener {
        private Component comp1;
        private Component comp2;
        private boolean btnFlag;

        CheckBoxItemListener(Component comp) {
            this.btnFlag = false;
            this.comp1 = comp;
        }

        CheckBoxItemListener(Component comp1, Component comp2) {
            this.btnFlag = true;
            this.comp1 = comp1;
            this.comp2 = comp2;
        }

        public void itemStateChanged(ItemEvent e) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                this.comp1.setEnabled(true);
                if (this.btnFlag) {
                    this.comp2.setEnabled(true);
                }
                this.comp1.requestFocusInWindow();
            } else {
                this.comp1.setEnabled(false);
                if (this.btnFlag) {
                    this.comp2.setEnabled(false);
                }
            }
        }
    }
}

