/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jhime.pectin.plugins.GroupVector;
import jp.sourceforge.jhime.pectin.plugins.PluginGUIXMLAttributeDialog;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLDocument;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultXMLDocument
extends PluginXMLDocument {
    protected Document document = null;
    private JFrame frame;
    private int insertMode = 0;
    private String retStartString = null;
    private String retEndString = null;

    public DefaultXMLDocument(JFrame frame) {
        this.frame = frame;
    }

    private ArrayList getElementList(Element parent, String childName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(childName)) continue;
            list.add((Element)node);
        }
        return list;
    }

    private Element getElement(String name) {
        NodeList nodeList = this.document.getDocumentElement().getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("name").equals(name)) continue;
            return element;
        }
        return null;
    }

    private Element getElementByName(Element parent, String childName, String name) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(childName) || !((Element)node).getAttribute("name").equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private void templateAction(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 4) continue;
            this.retStartString = node.getNodeValue();
            return;
        }
        this.retStartString = null;
    }

    private int piAction(Element element) {
        ArrayList array = this.getElementList(element, "attribute");
        PluginGUIXMLAttributeDialog dlg = new PluginGUIXMLAttributeDialog(this.frame, element, array);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<?");
        buff.append(element.getAttribute("name"));
        buff.append(attr);
        buff.append("?>");
        this.retStartString = buff.toString();
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private void dtdAction(Element element) {
        Element rootElement = this.getElementByName(element, "attribute", "root");
        Element publicElement = this.getElementByName(element, "attribute", "public");
        Element systemElement = this.getElementByName(element, "attribute", "system");
        StringBuffer buff = new StringBuffer("<!DOCTYPE ");
        if (null != rootElement) {
            buff.append(rootElement.getAttribute("value"));
        }
        if (null != publicElement) {
            buff.append(" PUBLIC ");
            buff.append("\"");
            buff.append(publicElement.getAttribute("value"));
            buff.append("\"");
        }
        if (null != systemElement) {
            if (null != publicElement) {
                buff.append(" ");
            } else {
                buff.append(" SYSTEM ");
            }
            buff.append("\"");
            buff.append(systemElement.getAttribute("value"));
            buff.append("\"");
        }
        buff.append(">");
        this.retStartString = buff.toString();
    }

    private int attributeListAction(Element element) {
        ArrayList array = this.getElementList(element, "attribute");
        PluginGUIXMLAttributeDialog dlg = new PluginGUIXMLAttributeDialog(this.frame, element, array);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int elementAction(Element element, boolean attrFlag) {
        PluginGUIXMLAttributeDialog dlg;
        Element attrElement;
        int i;
        if (!attrFlag) {
            attrFlag = element.getAttribute("attribute").equals("yes");
        }
        ArrayList array = this.getElementList(element, "attribute");
        ArrayList arrayList = this.getElementList(element, "attributeList");
        ArrayList<Element> generalAttrList = new ArrayList<Element>();
        for (i = 0; i < arrayList.size(); ++i) {
            attrElement = (Element)arrayList.get(i);
            String name = attrElement.getAttribute("name");
            Element listElement = this.getElement(name);
            if (null == listElement) continue;
            generalAttrList.add(listElement);
        }
        if (!attrFlag) {
            for (i = 0; i < array.size() && !(attrFlag = (attrElement = (Element)array.get(i)).getAttribute("required").equals("required")); ++i) {
            }
        }
        String attr = "";
        if (attrFlag && (array.size() > 0 || arrayList.size() > 0) && null == (attr = (dlg = new PluginGUIXMLAttributeDialog(this.frame, element, array, generalAttrList)).getString())) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        boolean emptyFlag = element.getAttribute("empty").equals("empty");
        this.retStartString = "<" + element.getAttribute("name") + attr;
        if (emptyFlag) {
            this.retStartString = this.retStartString + " />";
            return PluginXMLDocument.INSERT_SINGLE_MODE;
        }
        this.retStartString = this.retStartString + ">";
        this.retEndString = "</" + element.getAttribute("name") + ">";
        return PluginXMLDocument.INSERT_RANGE_MODE;
    }

    protected void readDocument() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream is = ClassLoader.getSystemResource("xhtml.xml").openStream();
            this.document = builder.parse(is);
            is.close();
        }
        catch (ParserConfigurationException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u69cb\u6210\u30a8\u30e9\u30fc");
        }
        catch (SAXException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "SAX\u30a8\u30e9\u30fc");
        }
        catch (IOException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
            this.document = null;
        }
    }

    public String toString() {
        return "XHTML";
    }

    public Vector getDocumentList() {
        if (null == this.document) {
            this.readDocument();
            if (null == this.document) {
                return null;
            }
        }
        Vector<GroupVector> group = new Vector<GroupVector>();
        ArrayList groupList = this.getElementList(this.document.getDocumentElement(), "group");
        for (int i = 0; i < groupList.size(); ++i) {
            Element groupNode = (Element)groupList.get(i);
            GroupVector element = new GroupVector(groupNode.getAttribute("name"));
            ArrayList elementList = this.getElementList(groupNode, "element");
            for (int j = 0; j < elementList.size(); ++j) {
                Element elementNode = (Element)elementList.get(j);
                element.add(elementNode.getAttribute("name"));
            }
            group.add(element);
        }
        return group;
    }

    public boolean getSelectButtonStatus() {
        return true;
    }

    public String getSelectButtonTitle() {
        return "\u5c5e\u6027\u8a2d\u5b9a";
    }

    public void createString(Object obj) {
        this.insertMode = PluginXMLDocument.CANCEL_MODE;
        if (null == obj || !obj.getClass().getName().equals("java.lang.String")) {
            return;
        }
        Element element = this.getElement((String)obj);
        if (null == element) {
            return;
        }
        String type = element.getAttribute("type");
        if (type.equals("template")) {
            this.templateAction(element);
            this.insertMode = PluginXMLDocument.INSERT_SINGLE_MODE;
        } else if (type.equals("pi")) {
            this.insertMode = this.piAction(element);
        } else if (type.equals("dtd")) {
            this.dtdAction(element);
            this.insertMode = PluginXMLDocument.INSERT_SINGLE_MODE;
        } else if (type.equals("attrlist")) {
            this.insertMode = this.attributeListAction(element);
        } else if (type.equals("element")) {
            this.insertMode = this.elementAction(element, false);
        }
    }

    public void createStringAlias(Object obj) {
        this.insertMode = PluginXMLDocument.CANCEL_MODE;
        if (null == obj || !obj.getClass().getName().equals("java.lang.String")) {
            return;
        }
        Element element = this.getElement((String)obj);
        if (null == element) {
            return;
        }
        String type = element.getAttribute("type");
        if (type.equals("template")) {
            this.templateAction(element);
            this.insertMode = PluginXMLDocument.INSERT_SINGLE_MODE;
        } else if (type.equals("pi")) {
            this.insertMode = this.piAction(element);
        } else if (type.equals("dtd")) {
            this.dtdAction(element);
            this.insertMode = PluginXMLDocument.INSERT_SINGLE_MODE;
        } else if (type.equals("attrlist")) {
            this.insertMode = this.attributeListAction(element);
        } else if (type.equals("element")) {
            this.insertMode = this.elementAction(element, true);
        }
    }

    public int getInsertMode() {
        return this.insertMode;
    }

    public String getStartString() {
        return this.retStartString;
    }

    public String getEndString() {
        return this.retEndString;
    }
}

