/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jhime.pectin.plugins.GroupVector;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributeDialog;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLDocument;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIAtCharsetPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIAtImportPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIAtMediaPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIBackgroundPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIBorderPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIDisplayPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIDisplaySizePanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIEffectPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIFontPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIListPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIMarginPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIPaddingPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUITablePanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUITextPanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUIUserInterfacePanel;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultCSSDocument
extends PluginXMLDocument {
    protected Document document = null;
    private JFrame frame;
    private int insertMode = 0;
    private String retStartString = null;
    private String retEndString = null;

    public DefaultCSSDocument(JFrame frame) {
        this.frame = frame;
    }

    private ArrayList getElementList(Element parent, String childName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(childName)) continue;
            list.add((Element)node);
        }
        return list;
    }

    private Element getElement(String name) {
        NodeList nodeList = this.document.getDocumentElement().getElementsByTagName("element");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("name").equals(name)) continue;
            return element;
        }
        return null;
    }

    private Element getElementByName(Element parent, String childName, String name) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(childName) || !((Element)node).getAttribute("name").equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private void templateAction(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 4) continue;
            this.retStartString = node.getNodeValue();
            return;
        }
        this.retStartString = null;
    }

    private void selectorAction(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 4) continue;
            this.retStartString = node.getNodeValue() + " {\n";
            this.retEndString = "}";
            return;
        }
        this.retStartString = null;
        this.retEndString = null;
    }

    private int attributeListAction(Element element) {
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int backgroundAction() {
        PluginGUIBackgroundPanel panel = new PluginGUIBackgroundPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int fontAction() {
        PluginGUIFontPanel panel = new PluginGUIFontPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int textAction() {
        PluginGUITextPanel panel = new PluginGUITextPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int boxAction() {
        Vector<PluginGUICSSAttributePanel> panels = new Vector<PluginGUICSSAttributePanel>();
        panels.add(new PluginGUIMarginPanel());
        panels.add(new PluginGUIPaddingPanel());
        panels.add(new PluginGUIBorderPanel());
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panels, "\u30dc\u30c3\u30af\u30b9\u306e\u8a2d\u5b9a");
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int visualFormatAction() {
        Vector<PluginGUICSSAttributePanel> panels = new Vector<PluginGUICSSAttributePanel>();
        panels.add(new PluginGUIDisplayPanel());
        panels.add(new PluginGUIDisplaySizePanel());
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panels, "\u8996\u899a\u6574\u5f62\u306e\u8a2d\u5b9a");
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int visualEffectAction() {
        PluginGUIEffectPanel panel = new PluginGUIEffectPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int tableAction() {
        PluginGUITablePanel panel = new PluginGUITablePanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int listAction() {
        PluginGUIListPanel panel = new PluginGUIListPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int userInterfaceAction() {
        PluginGUIUserInterfacePanel panel = new PluginGUIUserInterfacePanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int atCharsetAction() {
        PluginGUIAtCharsetPanel panel = new PluginGUIAtCharsetPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int atImportAction() {
        PluginGUIAtImportPanel panel = new PluginGUIAtImportPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr;
        return PluginXMLDocument.INSERT_SINGLE_MODE;
    }

    private int atMediaAction() {
        PluginGUIAtMediaPanel panel = new PluginGUIAtMediaPanel();
        PluginGUICSSAttributeDialog dlg = new PluginGUICSSAttributeDialog(this.frame, panel);
        String attr = dlg.getString();
        if (null == attr) {
            return PluginXMLDocument.CANCEL_MODE;
        }
        this.retStartString = attr + " {\n";
        this.retEndString = "}";
        return PluginXMLDocument.INSERT_RANGE_MODE;
    }

    protected void readDocument() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream is = ClassLoader.getSystemResource("css.xml").openStream();
            this.document = builder.parse(is);
            is.close();
        }
        catch (ParserConfigurationException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u69cb\u6210\u30a8\u30e9\u30fc");
        }
        catch (SAXException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "SAX\u30a8\u30e9\u30fc");
        }
        catch (IOException e) {
            StaticUtil.errorMessage("\u7d44\u8fbc\u307fXML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
            this.document = null;
        }
    }

    public String toString() {
        return "CSS";
    }

    public Vector getDocumentList() {
        if (null == this.document) {
            this.readDocument();
            if (null == this.document) {
                return null;
            }
        }
        Vector<GroupVector> group = new Vector<GroupVector>();
        ArrayList groupList = this.getElementList(this.document.getDocumentElement(), "group");
        for (int i = 0; i < groupList.size(); ++i) {
            Element groupNode = (Element)groupList.get(i);
            GroupVector element = new GroupVector(groupNode.getAttribute("name"));
            ArrayList elementList = this.getElementList(groupNode, "element");
            for (int j = 0; j < elementList.size(); ++j) {
                Element elementNode = (Element)elementList.get(j);
                element.add(elementNode.getAttribute("name"));
            }
            group.add(element);
        }
        return group;
    }

    public boolean getSelectButtonStatus() {
        return true;
    }

    public String getSelectButtonTitle() {
        return "\u9078 \u629e";
    }

    public void createString(Object obj) {
        this.insertMode = PluginXMLDocument.CANCEL_MODE;
        if (null == obj || !obj.getClass().getName().equals("java.lang.String")) {
            return;
        }
        Element element = this.getElement((String)obj);
        if (null == element) {
            return;
        }
        String type = element.getAttribute("type");
        if (type.equals("template")) {
            this.templateAction(element);
            this.insertMode = PluginXMLDocument.INSERT_SINGLE_MODE;
        } else if (type.equals("selector")) {
            this.selectorAction(element);
            this.insertMode = PluginXMLDocument.INSERT_RANGE_MODE;
        } else if (type.equals("css:background")) {
            this.insertMode = this.backgroundAction();
        } else if (type.equals("css:font")) {
            this.insertMode = this.fontAction();
        } else if (type.equals("css:text")) {
            this.insertMode = this.textAction();
        } else if (type.equals("css:box")) {
            this.insertMode = this.boxAction();
        } else if (type.equals("css:vformat")) {
            this.insertMode = this.visualFormatAction();
        } else if (type.equals("css:veffect")) {
            this.insertMode = this.visualEffectAction();
        } else if (type.equals("css:table")) {
            this.insertMode = this.tableAction();
        } else if (type.equals("css:list")) {
            this.insertMode = this.listAction();
        } else if (type.equals("css:userif")) {
            this.insertMode = this.userInterfaceAction();
        } else if (type.equals("@charset")) {
            this.insertMode = this.atCharsetAction();
        } else if (type.equals("@import")) {
            this.insertMode = this.atImportAction();
        } else if (type.equals("@media")) {
            this.insertMode = this.atMediaAction();
        }
    }

    public void createStringAlias(Object obj) {
        this.createString(obj);
    }

    public int getInsertMode() {
        return this.insertMode;
    }

    public String getStartString() {
        return this.retStartString;
    }

    public String getEndString() {
        return this.retEndString;
    }
}

