/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.model;

import jp.sourceforge.jhime.pectin.model.XmlModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlModelElement
extends XmlModel {
    private boolean empty;
    private boolean attribute;

    public XmlModelElement(String name, boolean empty, boolean attribute) {
        this.setName(name);
        this.setType("element");
        this.empty = empty;
        this.attribute = attribute;
    }

    public XmlModelElement(Element docNode, Element element) {
        super(docNode, element);
        this.empty = this.getEmpty(element);
        this.attribute = this.getAttribute(element);
    }

    private boolean getEmpty(Element element) {
        return element.getAttributeNode("empty") != null;
    }

    private boolean getAttribute(Element element) {
        return element.getAttributeNode("attribute") != null;
    }

    public boolean getEmpty() {
        return this.empty;
    }

    public boolean getAttribute() {
        return this.attribute;
    }

    public Element createElement(Document doc) {
        String name = this.getName();
        boolean empty = this.getEmpty();
        boolean attribute = this.getAttribute();
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Element elementElement = doc.createElement("element");
        elementElement.setAttribute("name", name);
        if (empty) {
            elementElement.setAttribute("empty", "empty");
        }
        if (attribute) {
            elementElement.setAttribute("attribute", "attribute");
        }
        return elementElement;
    }
}

