/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.imgconv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.imgconv.Convert;
import jp.sourceforge.jhime.pectin.imgconv.ImagePreviewPanel;
import jp.sourceforge.jhime.pectin.imgconv.ResultDialog;
import jp.sourceforge.jhime.pectin.io.ImageIOFilter;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class ImageConvertDialog
extends JDialog
implements WindowListener {
    private JFrame frame;
    private JButton convertBtn;
    private JButton closeBtn;
    private JList fileList = new JList(new DefaultListModel());
    private JButton appendBtn = new JButton("\u5909\u63db\u5143\u753b\u50cf\u8ffd\u52a0");
    private JButton deleteBtn = new JButton("\u5909\u63db\u5143\u753b\u50cf\u524a\u9664");
    private JTextField dirField = new JTextField(System.getProperty("user.home"), 30);
    private JButton dirBtn = new JButton("\u53c2 \u7167");
    private JCheckBox widthBtn = new JCheckBox("\u5e45", true);
    private JTextField widthField = new JTextField("320", 5);
    private JCheckBox heightBtn = new JCheckBox("\u9ad8\u3055", true);
    private JTextField heightField = new JTextField("240", 5);
    private JCheckBox quolityBtn = new JCheckBox("\u753b\u8cea\u512a\u5148", true);

    public ImageConvertDialog(JFrame frame) {
        super((Frame)frame, "\u753b\u50cf\u30b5\u30a4\u30ba\u5909\u63db");
        this.frame = frame;
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.closeBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.convertBtn = new JButton("\u5909\u63db");
        this.closeBtn = new JButton("\u9589\u3058\u308b");
        this.convertBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageConvertDialog.this.convert();
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageConvertDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.convertBtn);
        pan.add(this.closeBtn);
        return pan;
    }

    private JPanel createPanel() {
        this.action();
        this.dirField.setEditable(false);
        JScrollPane spane = new JScrollPane(this.fileList);
        GUIGridPanel pan = new GUIGridPanel();
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("\u5909\u63db\u5143\u753b\u50cf\u30ea\u30b9\u30c8"), 0, 0);
        pan.setWidth(8);
        pan.setHeight(3);
        pan.gridLayoutComponent(spane, 0, 1);
        pan.setWidth(1);
        pan.setHeight(1);
        pan.gridLayoutComponent(this.appendBtn, 8, 1);
        pan.gridLayoutComponent(this.deleteBtn, 8, 2);
        pan.setWidth(2);
        pan.gridLayoutComponent(new JLabel("\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0"), 0, 4);
        pan.setWidth(6);
        pan.gridLayoutComponent(this.dirField, 2, 4);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.dirBtn, 8, 4);
        pan.gridLayoutComponent(this.widthBtn, 0, 5);
        pan.setWidth(2);
        pan.gridLayoutComponent(this.widthField, 1, 5);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.heightBtn, 3, 5);
        pan.gridLayoutComponent(this.heightField, 4, 5);
        pan.gridLayoutComponent(this.quolityBtn, 5, 5);
        return pan;
    }

    private void action() {
        this.appendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageConvertDialog.this.appendImage();
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageConvertDialog.this.deleteImage();
            }
        });
        this.dirBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageConvertDialog.this.saveDirPosition();
            }
        });
        this.widthBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ImageConvertDialog.this.checkBoxButtonListener(e);
            }
        });
        this.heightBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ImageConvertDialog.this.checkBoxButtonListener(e);
            }
        });
    }

    private void appendImage() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("\u5909\u63db\u5143\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a");
        fc.setMultiSelectionEnabled(true);
        fc.setAcceptAllFileFilterUsed(false);
        ImageIOFilter fl = new ImageIOFilter("jpeg/png/gif");
        fc.addChoosableFileFilter(fl);
        fc.addChoosableFileFilter(new ImageIOFilter("jpeg"));
        fc.addChoosableFileFilter(new ImageIOFilter("png"));
        fc.addChoosableFileFilter(new ImageIOFilter("gif"));
        fc.setFileFilter(fl);
        fc.setAccessory(new ImagePreviewPanel(fc));
        if (0 != fc.showOpenDialog(this)) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        for (int i = 0; i < files.length; ++i) {
            ((DefaultListModel)this.fileList.getModel()).addElement(files[i]);
        }
    }

    private void deleteImage() {
        int idx = this.fileList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        int[] idxList = this.fileList.getSelectedIndices();
        for (int i = idxList.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.fileList.getModel()).remove(idxList[i]);
        }
    }

    private void saveDirPosition() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("\u5909\u63db\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u4fdd\u5b58\u5148\u30d5\u30a9\u30eb\u30c0\u6307\u5b9a");
        fc.setDialogType(1);
        fc.setFileSelectionMode(1);
        if (0 != fc.showOpenDialog(this)) {
            return;
        }
        this.dirField.setText(fc.getSelectedFile().getPath());
    }

    private void checkBoxButtonListener(ItemEvent e) {
        Object obj = e.getSource();
        JTextField field = null;
        if (obj.equals(this.widthBtn)) {
            field = this.widthField;
        } else if (obj.equals(this.heightBtn)) {
            field = this.heightField;
        }
        if (((JCheckBox)obj).isSelected()) {
            field.setEnabled(true);
            field.requestFocusInWindow();
        } else {
            field.setEnabled(false);
        }
    }

    private void convert() {
        if (this.fileList.getModel().getSize() <= 0) {
            StaticUtil.errorMessage("\u5909\u63db\u5143\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        if (!this.widthBtn.isSelected() && !this.heightBtn.isSelected()) {
            StaticUtil.errorMessage("\u5909\u63db\u5f8c\u306e\u5e45\u3042\u308b\u3044\u306f\u9ad8\u3055\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return;
        }
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(this.widthField.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            height = Integer.parseInt(this.heightField.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (width == 0 && height == 0) {
            StaticUtil.errorMessage("\u5e45\u3001\u9ad8\u3055\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059", "\u30a8\u30e9\u30fc");
            return;
        }
        ListModel model = this.fileList.getModel();
        Vector fileVector = new Vector();
        for (int i = 0; i < model.getSize(); ++i) {
            fileVector.add(model.getElementAt(i));
        }
        ResultDialog dlg = new ResultDialog(this);
        Dimension dim = new Dimension(width, height);
        Convert conv = new Convert(fileVector, dlg, dim, this.dirField.getText(), this.quolityBtn.isSelected());
        conv.start();
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

