/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.imgconv;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import jp.sourceforge.jhime.pectin.imgconv.ResultDialog;

public class Convert
extends Thread {
    private Vector fileList;
    private ResultDialog dlg;
    private int width;
    private int height;
    private String folder;
    private boolean scaleMode;

    public Convert(Vector fileList, ResultDialog dlg, Dimension dim, String folder, boolean scaleMode) {
        this.fileList = fileList;
        this.dlg = dlg;
        this.width = dim.width;
        this.height = dim.height;
        this.folder = folder;
        this.scaleMode = scaleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(File file) {
        String separator = System.getProperty("file.separator");
        String fileName = file.getName();
        String pathName = this.folder;
        if (!pathName.endsWith(separator)) {
            pathName = pathName + separator;
        }
        String outImg = pathName + fileName;
        String extName = null;
        if (fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".jpeg")) {
            extName = "jpg";
        } else if (fileName.toLowerCase().endsWith(".png")) {
            extName = "png";
        } else if (fileName.toLowerCase().endsWith(".gif")) {
            extName = "gif";
        }
        Iterator<ImageReader> itr = ImageIO.getImageReadersByFormatName(extName);
        ImageReader imgr = null;
        while (itr.hasNext()) {
            imgr = itr.next();
        }
        Iterator<ImageWriter> ito = ImageIO.getImageWritersByFormatName(extName);
        ImageWriter imgo = null;
        while (ito.hasNext()) {
            imgo = ito.next();
        }
        if (imgr == null || imgo == null) {
            this.dlg.appendText(file.toString() + ": \u3053\u306e\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093->");
            return;
        }
        InputStream is = null;
        try {
            this.dlg.appendText(file.toString() + ":\u8aad\u307f\u8fbc\u307f->");
            ImageInputStream iis = ImageIO.createImageInputStream(file);
            imgr.setInput(iis);
            BufferedImage img = imgr.read(0);
            int r_width = this.width;
            int r_height = this.height;
            if (this.width == 0) {
                r_width = (int)((double)this.height / (double)img.getHeight() * (double)img.getWidth());
            } else if (this.height == 0) {
                r_height = (int)((double)this.width / (double)img.getWidth() * (double)img.getHeight());
            }
            BufferedImage resizeImage = new BufferedImage(r_width, r_height, 5);
            this.dlg.appendText("\u5909\u63db->");
            int mode = 16;
            if (!this.scaleMode) {
                mode = 2;
            }
            resizeImage.getGraphics().drawImage(img.getScaledInstance(r_width, r_height, mode), 0, 0, r_width, r_height, null);
            this.dlg.appendText("\u66f8\u304d\u8fbc\u307f->");
            File outFile = new File(outImg);
            if (outFile.exists()) {
                outFile = new File(pathName + "00_" + fileName);
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(outFile);
            imgo.setOutput(ios);
            imgo.write(resizeImage);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    System.out.println(file + " close error");
                }
            }
        }
    }

    public void run() {
        for (int i = 0; i < this.fileList.size(); ++i) {
            this.resize((File)this.fileList.get(i));
            this.dlg.appendText("\u7d42\u4e86\n");
        }
        this.dlg.appendText("\u5909\u63db\u7d42\u4e86\n");
    }
}

