/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.gui.GUIXmlTemplateDialog2;
import jp.sourceforge.jhime.pectin.model.XmlModelTemplate;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIXmlTemplateDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private XMLDocument xmlDoc;
    private JButton okBtn;
    private JComboBox documentBox;
    private JList templateList;
    private DefaultListModel templateModel;
    private JTextArea templateArea;
    private JButton tempAppendBtn;
    private JButton tempRemoveBtn;
    private JButton tempUpdateBtn;
    private JButton tempUpBtn;
    private JButton tempDownBtn;

    public GUIXmlTemplateDialog(GUIFrame obj) {
        super((Frame)null, "XML\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u5b9a\u7fa9", true);
        int h;
        int w;
        this.appObject = obj;
        this.xmlDoc = XMLDocumentUser.newInstance();
        this.paramInitialize();
        if (this.documentBox.getItemCount() <= 0) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return;
        }
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        this.getContentPane().add((Component)new JLabel(""), "West");
        this.getContentPane().add((Component)new JLabel(""), "East");
        pan.getRootPane().setDefaultButton(this.okBtn);
        this.initStatus();
        this.pack();
        Rectangle rect = this.getGraphicsConfiguration().getBounds();
        if (rect.x < 0) {
            int x = rect.x;
            w = 500;
        } else {
            w = rect.width / 2;
            int x = (rect.width - w) / 2;
        }
        if (rect.y < 0) {
            int y = rect.y;
            h = 400;
        } else {
            h = rect.height / 2;
            boolean y = false;
        }
        this.setSize(w, h);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u9589\u3058\u308b");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.transform();
                GUIXmlTemplateDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.documentBox = new JComboBox(this.xmlDoc.getDocumentList());
        this.templateModel = new DefaultListModel();
        this.templateList = new JList(this.templateModel);
        this.templateArea = new JTextArea();
        this.templateArea.setEditable(false);
        ImageIcon iconAdd = new ImageIcon(ClassLoader.getSystemResource("images/add.png"));
        ImageIcon iconDelete = new ImageIcon(ClassLoader.getSystemResource("images/delete.png"));
        ImageIcon iconWrench = new ImageIcon(ClassLoader.getSystemResource("images/wrench.png"));
        ImageIcon iconUp = new ImageIcon(ClassLoader.getSystemResource("images/arrow_up.png"));
        ImageIcon iconDown = new ImageIcon(ClassLoader.getSystemResource("images/arrow_down.png"));
        this.tempAppendBtn = new JButton(iconAdd);
        this.tempRemoveBtn = new JButton(iconDelete);
        this.tempUpdateBtn = new JButton(iconWrench);
        this.tempUpBtn = new JButton(iconUp);
        this.tempDownBtn = new JButton(iconDown);
        this.tempAppendBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u8ffd\u52a0");
        this.tempRemoveBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u524a\u9664");
        this.tempUpdateBtn.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u306e\u4fee\u6b63");
        this.tempUpBtn.setToolTipText("\uff11\u3064\u4e0a\u3078");
        this.tempDownBtn.setToolTipText("\uff11\u3064\u4e0b\u3078");
    }

    private JPanel createContentsPanel() {
        this.addAction();
        JScrollPane tempScrPane = new JScrollPane(this.templateList);
        JScrollPane textScrPane = new JScrollPane(this.templateArea);
        JPanel tempBtnPane = new JPanel(new GridLayout(1, 5));
        tempBtnPane.add(this.tempAppendBtn);
        tempBtnPane.add(this.tempRemoveBtn);
        tempBtnPane.add(this.tempUpdateBtn);
        tempBtnPane.add(this.tempUpBtn);
        tempBtnPane.add(this.tempDownBtn);
        JPanel tempPan = new JPanel(new BorderLayout());
        tempPan.add((Component)new JLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30ea\u30b9\u30c8"), "North");
        tempPan.add((Component)tempBtnPane, "South");
        tempPan.add((Component)tempScrPane, "Center");
        JPanel textPan = new JPanel(new BorderLayout());
        textPan.add((Component)new JLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"), "North");
        textPan.add((Component)textScrPane, "Center");
        GUIGridPanel gpan = new GUIGridPanel();
        gpan.gridLayoutComponent(new JLabel("\u6587\u66f8\u578b"), 0, 0);
        gpan.gridLayoutComponent(this.documentBox, 1, 0);
        JPanel docPane = new JPanel(new FlowLayout(0));
        docPane.add(gpan);
        JPanel ppan = new JPanel(new BorderLayout(10, 5));
        ppan.add((Component)docPane, "North");
        ppan.add((Component)textPan, "Center");
        ppan.add((Component)tempPan, "West");
        return ppan;
    }

    private void addAction() {
        this.documentBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionDocumentList();
            }
        });
        this.templateList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateList();
            }
        });
        this.tempAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateAppend();
            }
        });
        this.tempRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateDelete();
            }
        });
        this.tempUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateUpdate();
            }
        });
        this.templateList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    GUIXmlTemplateDialog.this.actionTemplateUpdate();
                }
            }
        });
        this.tempUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateUpDown(true);
            }
        });
        this.tempDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlTemplateDialog.this.actionTemplateUpDown(false);
            }
        });
    }

    private void setTemplateBtnEnabled(boolean flag) {
        this.tempAppendBtn.setEnabled(flag);
        this.tempUpdateBtn.setEnabled(flag);
        this.tempRemoveBtn.setEnabled(flag);
        this.tempUpBtn.setEnabled(flag);
        this.tempDownBtn.setEnabled(flag);
    }

    private void initStatus() {
        this.setTemplateBtnEnabled(false);
        try {
            this.documentBox.setSelectedIndex(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void actionDocumentList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        if (documentName == null) {
            return;
        }
        this.setTemplateBtnEnabled(true);
        this.templateModel.clear();
        this.templateModel = this.xmlDoc.getTemplateList(this.templateModel, documentName);
        this.templateList.setSelectedIndex(0);
    }

    private void actionTemplateList() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String templateName = (String)this.templateList.getSelectedValue();
        if (documentName == null || templateName == null) {
            this.templateArea.setText("");
            return;
        }
        XmlModelTemplate model = this.xmlDoc.getTemplateModel(documentName, templateName);
        if (model == null) {
            this.templateArea.setText("");
            return;
        }
        this.templateArea.setText(model.getString());
    }

    private void actionTemplateAppend() {
        String documentName = (String)this.documentBox.getSelectedItem();
        GUIXmlTemplateDialog2 dlg = new GUIXmlTemplateDialog2(this.appObject, this.xmlDoc, documentName);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.appendTemplate(documentName, dlg.getModel())) {
            return;
        }
        this.templateModel.addElement(dlg.getModel().getName());
        this.templateList.setSelectedIndex(this.templateModel.size() - 1);
    }

    private void actionTemplateDelete() {
        String templateName = (String)this.templateList.getSelectedValue();
        if (templateName == null) {
            return;
        }
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(templateName + " \u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        String docName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.removeTemplate(docName, templateName)) {
            return;
        }
        int idx = this.templateModel.indexOf(templateName);
        this.templateModel.removeElement(templateName);
        if (idx >= this.templateModel.size()) {
            idx = this.templateModel.size() - 1;
        }
        if (idx < 0) {
            return;
        }
        this.templateList.setSelectedIndex(idx);
        this.templateList.requestFocusInWindow();
    }

    private void actionTemplateUpdate() {
        String documentName = (String)this.documentBox.getSelectedItem();
        String templateName = (String)this.templateList.getSelectedValue();
        if (documentName == null || templateName == null) {
            return;
        }
        XmlModelTemplate model = this.xmlDoc.getTemplateModel(documentName, templateName);
        if (model == null) {
            return;
        }
        GUIXmlTemplateDialog2 dlg = new GUIXmlTemplateDialog2(this.appObject, this.xmlDoc, documentName, model, true);
        if (dlg.getModel() == null) {
            return;
        }
        if (!this.xmlDoc.updateTemplate(documentName, templateName, dlg.getModel())) {
            return;
        }
        model = this.xmlDoc.getTemplateModel(documentName, dlg.getModel().getName());
        this.templateArea.setText(model.getString());
        int idx = this.templateList.getSelectedIndex();
        this.templateModel.set(idx, dlg.getModel().getName());
        this.templateList.setSelectedIndex(idx);
        this.templateList.requestFocusInWindow();
    }

    private void actionTemplateUpDown(boolean upFlag) {
        int eIdx;
        int sIdx;
        int idx = this.templateList.getSelectedIndex();
        if (upFlag) {
            if (idx <= 0) {
                return;
            }
            sIdx = idx - 1;
            eIdx = idx;
        } else {
            if (idx >= this.templateModel.size() - 1) {
                return;
            }
            sIdx = idx;
            eIdx = idx + 1;
        }
        String elm1 = (String)this.templateModel.get(sIdx);
        String elm2 = (String)this.templateModel.get(eIdx);
        String documentName = (String)this.documentBox.getSelectedItem();
        if (!this.xmlDoc.templateUpDown(documentName, elm1, elm2)) {
            return;
        }
        this.templateModel.set(sIdx, elm2);
        this.templateModel.set(eIdx, elm1);
        if (!upFlag) {
            sIdx = eIdx;
        }
        this.templateList.setSelectedIndex(sIdx);
        this.templateList.requestFocusInWindow();
    }

    private void transform() {
        this.xmlDoc.transform();
        this.appObject.getUserXmlPanel().update();
    }

    public void windowClosing(WindowEvent e) {
        this.transform();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

